/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.java.internal.codegen;

import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.models.common.facades.behavioral.IAction;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.test.common.internal.codegen.Helper;
import org.eclipse.hyades.test.common.internal.codegen.ImportManager;
import org.eclipse.hyades.ui.internal.util.StringUtil;

class GenTestSuite
{
  protected final String NL = System.getProperties().getProperty("line.separator");
  protected final String TEXT_1 = "\t\t" + NL;
  protected final String TEXT_2 = NL + "package ";
  protected final String TEXT_3 = ";" + NL;
  protected final String TEXT_4 = NL + NL + "/**" + NL + " * Generated code for the test suite <b>";
  protected final String TEXT_5 = "</b> located at" + NL + " * <i>";
  protected final String TEXT_6 = "</i>";
  protected final String TEXT_7 = ".";
  protected final String TEXT_8 = NL + " *" + NL + " * ";
  protected final String TEXT_9 = NL + " */" + NL + "public class ";
  protected final String TEXT_10 = NL + "extends ";
  protected final String TEXT_11 = NL + "{" + NL + "\t/**" + NL + "\t * Constructor for ";
  protected final String TEXT_12 = "." + NL + "\t * @param name" + NL + "\t */" + NL + "\tpublic ";
  protected final String TEXT_13 = "(String name)" + NL + "\t{" + NL + "\t\tsuper(name);" + NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * Returns the JUnit test suite that implements the <b>";
  protected final String TEXT_14 = "</b>" + NL + "\t * definition." + NL + "\t */" + NL + "\tpublic static Test suite()" + NL + "\t{";
  protected final String TEXT_15 = "\t\t";
  protected final String TEXT_16 = " ";
  protected final String TEXT_17 = " = new ";
  protected final String TEXT_18 = "(\"";
  protected final String TEXT_19 = "\");" + NL + "\t\t";
  protected final String TEXT_20 = ".setArbiter(DefaultTestArbiter.INSTANCE).setId(\"";
  protected final String TEXT_21 = "\");" + NL + "\t\t";
  protected final String TEXT_22 = NL + "        ";
  protected final String TEXT_23 = NL + NL + "\t\treturn ";
  protected final String TEXT_24 = ";" + NL + "\t}" + NL + "\t" + NL + "\t/**" + NL + "\t * @see junit.framework.TestCase#setUp()" + NL + "\t */" + NL + "\tprotected void setUp()" + NL + "\tthrows ";
  protected final String TEXT_25 = NL + "\t{" + NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * @see junit.framework.TestCase#tearDown()" + NL + "\t */" + NL + "\tprotected void tearDown()" + NL + "\tthrows ";
  protected final String TEXT_26 = NL + "\t{" + NL + "\t}\t";
  protected final String TEXT_27 = NL + NL + "/**" + NL + " * ";
  protected final String TEXT_28 = NL + " *" + NL + " * ";
  protected final String TEXT_29 = NL + " * ";
  protected final String TEXT_30 = NL + " * @throws ";
  protected final String TEXT_31 = NL + " */" + NL + "\tpublic void ";
  protected final String TEXT_32 = "()" + NL + "\tthrows ";
  protected final String TEXT_33 = NL + "\t{" + NL + "\t\t";
  protected final String TEXT_34 = NL + "\t}";
  protected final String TEXT_35 = NL;
  protected final String TEXT_36 = "}";

	public String generate(ITestSuite testSuite, final Helper helper)
  {
    StringBuffer stringBuffer = new StringBuffer();
    stringBuffer.append(TEXT_1);
    
	class MethodBodyGenerator
	{
		public StringBuffer generate(ITestCase testCase)
		{
			StringBuffer sb = new StringBuffer();
			sb.append("// Enter your code here");
			return sb;
		}
	}

    
	class InvocationGenerator
	{
		private String hyadesTestSuiteClassName;
		
		public InvocationGenerator(String hyadesTestSuiteClassName)
		{
			this.hyadesTestSuiteClassName = hyadesTestSuiteClassName;
		}
		
		public StringBuffer generate(String owner, List actions)
		{
			StringBuffer code = new StringBuffer();
			StringBuffer sb = new StringBuffer();
			for(Iterator i=actions.iterator(); i.hasNext();)
			{
				IAction action = (IAction)i.next();
				
				if(action instanceof ITestInvocation)
					sb = generate(owner, (ITestInvocation)action);
				else if(action instanceof ILoop)
					sb = generate(owner, (ILoop)action);
				else
					continue;

				if (sb == null)
				{ //error condition
					//code.append(NL).append("//ERROR: No definition found for test element: ").append(action.getName()).append(NL).append(NL);
					continue;	
				}					

				if(sb.length() == 0)
					continue;
				
				if(code.length() > 0)
					code.append(NL).append(NL);
				code.append(sb.toString());
			}

			return code;
		}
		
		private StringBuffer generate(String owner, ITestInvocation testInvocation)
		{
			StringBuffer sb = new StringBuffer(owner).append(".addTest(");
			ITest invokedTest = testInvocation.getInvokedTest();
			if(invokedTest == null)
				return null;
				
			if(invokedTest instanceof ITestSuite)
			{
				sb.append("((").append(hyadesTestSuiteClassName).append(")").append(helper.getImportedName(invokedTest.getImplementor().getResource())).append(".suite())");
			}
			else
			{
				ITestCase testCase = (ITestCase)invokedTest;
				String identifier = testCase.getImplementor().getResource();
				if(identifier == null)
					identifier = helper.retrieveIdentifierName(testCase, "METHOD");

				sb.append("new ").append(helper.getImportedName(testCase.getOwner().getImplementor().getResource())).append("(\"").append(identifier).append("\")");
				sb.append(".setId(\"").append(invokedTest.getId()).append("\")");
			}
			sb.append(".setTestInvocationId(\"").append(testInvocation.getId()).append("\")");			
			if(!testInvocation.isSynchronous())
				sb.append(".setSynchronous(false)");
			
			return sb.append(");");
		}

		private StringBuffer generate(String owner, ILoop loop)
		{
			String identifier = helper.retrieveIdentifierName(loop, "METHOD");
			String name = loop.getName();
			if(name == null)
				name = "";
			else
				name = "\"" + name + "\"";
				
			StringBuffer sb = new StringBuffer(hyadesTestSuiteClassName).append(" ").append(identifier);
			sb.append(" = new ").append(hyadesTestSuiteClassName).append("(").append(name).append(");").append(NL);
			sb.append(owner).append(".addTest(new ").append(helper.getImportedName("junit.extensions.RepeatedTest")).append("(").append(identifier).append(", ").append(loop.getCondition().getConstraint()).append("));").append(NL);
			sb.append(identifier).append(".setId(\"").append(loop.getId()).append("\")");
			if(!loop.isSynchronous())
				sb.append(".setSynchronous(false)");				
			sb.append(";");
			
			return sb.append(NL).append(NL).append(generate(identifier, loop.getBlock().getActions()).toString());
		}
	}

    
	String packageName = helper.getPackageName(testSuite);
	String className = helper.retrieveClassName(testSuite);
	String description = testSuite.getDescription();
	if(description != null)
		description = StringUtil.replace(description.trim(), NL, NL + " * ");
	else
		description = "";
		
	helper.setImportManager(new ImportManager(packageName));
	helper.getImportedName(packageName + "." + className);

    stringBuffer.append(TEXT_2);
    stringBuffer.append(packageName);
    stringBuffer.append(TEXT_3);
    
	helper.addImport("junit.framework.Test");
	helper.addImport("org.eclipse.hyades.test.common.junit.DefaultTestArbiter");
	helper.addImport("org.eclipse.hyades.test.common.junit.HyadesTestCase");
	helper.addImport("org.eclipse.hyades.test.common.junit.HyadesTestSuite");
	helper.markImportLocation(stringBuffer);

	final String hyadesTestSuiteClassName = helper.getImportedName("org.eclipse.hyades.test.common.junit.HyadesTestSuite");
	final String hyadesTestCaseClassName = helper.getImportedName("org.eclipse.hyades.test.common.junit.HyadesTestCase");
	String exceptionClassName = helper.getImportedName("java.lang.Exception");
	String filePath = helper.getFilePath(testSuite);

    stringBuffer.append(TEXT_4);
    stringBuffer.append(helper.getLabel(testSuite));
    if(filePath != null){
    stringBuffer.append(TEXT_5);
    stringBuffer.append(filePath);
    stringBuffer.append(TEXT_6);
    }
    stringBuffer.append(TEXT_7);
    if(description.length() > 0){
    stringBuffer.append(TEXT_8);
    stringBuffer.append(description);
    }
    stringBuffer.append(TEXT_9);
    stringBuffer.append(className);
    stringBuffer.append(TEXT_10);
    stringBuffer.append(hyadesTestCaseClassName);
    stringBuffer.append(TEXT_11);
    stringBuffer.append(className);
    stringBuffer.append(TEXT_12);
    stringBuffer.append(className);
    stringBuffer.append(TEXT_13);
    stringBuffer.append(helper.getLabel(testSuite));
    stringBuffer.append(TEXT_14);
     
		String javaElement = helper.retrieveIdentifierName(testSuite, "SUITE"); 
		String code = new InvocationGenerator(hyadesTestSuiteClassName).generate(javaElement, testSuite.getImplementor().getBlock().getActions()).toString();


    stringBuffer.append(TEXT_15);
    stringBuffer.append(hyadesTestSuiteClassName);
    stringBuffer.append(TEXT_16);
    stringBuffer.append(javaElement);
    stringBuffer.append(TEXT_17);
    stringBuffer.append(hyadesTestSuiteClassName);
    stringBuffer.append(TEXT_18);
    stringBuffer.append(helper.getLabel(testSuite));
    stringBuffer.append(TEXT_19);
    stringBuffer.append(javaElement);
    stringBuffer.append(TEXT_20);
    stringBuffer.append(testSuite.getId());
    stringBuffer.append(TEXT_21);
    stringBuffer.append(TEXT_22);
    stringBuffer.append(code);
    stringBuffer.append(TEXT_23);
    stringBuffer.append(javaElement);
    stringBuffer.append(TEXT_24);
    stringBuffer.append(exceptionClassName);
    stringBuffer.append(TEXT_25);
    stringBuffer.append(exceptionClassName);
    stringBuffer.append(TEXT_26);
    
	MethodBodyGenerator methodBodyGenerator = new MethodBodyGenerator();
	for(Iterator i=testSuite.getITestCases().iterator(); i.hasNext();)
	{
		ITestCase testCase = (ITestCase)i.next();
		
		code = methodBodyGenerator.generate(testCase).toString();
		String identifier = testCase.getImplementor().getResource();
		if(identifier == null)
			identifier = helper.retrieveIdentifierName(testCase, "METHOD");

		if(identifier != null)
		{
			description = testCase.getDescription();
			description = StringUtil.replace(description, NL, NL + " * ");

    stringBuffer.append(TEXT_27);
    stringBuffer.append(helper.getLabel(testCase));
    if(description != null){
    stringBuffer.append(TEXT_28);
    stringBuffer.append(description);
    stringBuffer.append(TEXT_29);
    }
    stringBuffer.append(TEXT_30);
    stringBuffer.append(exceptionClassName);
    stringBuffer.append(TEXT_31);
    stringBuffer.append(identifier);
    stringBuffer.append(TEXT_32);
    stringBuffer.append(exceptionClassName);
    stringBuffer.append(TEXT_33);
    stringBuffer.append(code);
    stringBuffer.append(TEXT_34);
    
		}
	}

    stringBuffer.append(TEXT_35);
    stringBuffer.append(TEXT_36);
    helper.emitSortedImports();
    
    return stringBuffer.toString();
  }
}
