/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.recorder.local.appadapters;


/**
 * Interface implemented by objects which will provide the client side functionality of an Recorder Application adatper.
 * relavent to extension point org.eclipse.hyades.execution.recorder.RecorderApplication
 * @author Ernest Jessee
 */
public interface IRecorderApplicationAdapterClient
{
	/**
	 * API for getting initialization info for the application adapter agent to use when starting the target application.
	 * This information can be anything as long as the adapter understand it.
	 * The adapter may have it's own preference page for acquiring this information from the user.  
	 * example:
	 * 	 port,450;host,localhost
	 * 
	 */
	public abstract String getInitString();
	
	/**
	 * API for setting initialization info for the application adapter.
	 * This information can be anything as long as the adapter understand it.
	 * The adapter may have it's own preference page for acquiring this information from the user.  
	 * example:
	 * 	 port,450;host,localhost
	 * 
	 */
	public abstract void setInitString(String initString);
}
