/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.internal.ui;

import org.eclipse.hyades.trace.ui.*;

public class TraceConstants {

	/**
	 * agent Type extension point
	 */
	public static final String AGENT_TYPE_EXT = "agentType";
    /**
     * trace extension
     */	
	public static final String TRACE_EXTENSION = "trace";

	public static final String HOST_TYPE = "Host";
	public static final String MONITOR_TYPE = "Monitor";


	// Constants
	public static final String TRACE_PROJECT_NAME = "prj_name";
	public static final String TRACE_MONITOR_NAME = "mon_name";
	public static final String LOG_OPTION_KEY = "log_option";
	public static final String PROF_OPTION_KEY = "prof_option";
	public static final String LOG_KEY = "log_agents";
	public static final String FILTERS_SET_KEY = "set_filters";
	public static final String ACTIVE_FILTER_NAME = "filter_name";
	public static final String PROFILE_TIPS = "profile_tips";
	
	public static final String PROFILING_SET_KEY = "set_profilingSets";

	public static final String NEW_SNAPSHOT_TIPS = "new_snapshot_tips";
	
	public static final String REFRESH_TYPE = "refresh_type";
	public static final String REFRESH_INTERVAL = "refresh_int";

	public static final String PROF_EXECUTION = "prof_execution";
	public static final String PROF_HEAP_SIZE = "prof_heap_size";
	public static final String PROF_EXECUTION_BOUNDARY = "prof_execution_boundary";
	public static final String PROF_EXEC_STAT = "prof_exec_stat";
	public static final String PROF_HEAP_STAT = "prof_heap_stat";
	public static final String PROF_HEAP_INST = "prof_heap_inst";
	public static final String PROF_AUTO_MONITOR = "prof_auto_monitor";
	public static final String PROF_COVERAGE = "prof_coverage";

	public static final String LAUNCH_MODE = "trace_launch";
	public static final String ATTACH_MODE = "trace_attach";

	public static final int TRACE_PROFILE = 2;
	public static final int TRACE_RAS = 4;
	public static final int TRACE_LOG = 8;

	public static final String PROFILE_AGENT_TYPE = "Profiler";
	public static final String LOG_AGENT_TYPE = "Logging";
	public static final String PROFILE_AGENT_NAME = "Java Profiling Agent";
	public static final String J2EE_AGENT_NAME = "J2EE Request Profiler";
	public static final String LOG_AGENT_NAME = "Default Logging Agent";

	public static final String MONITOR_EXT = "trcmxmi";
	public static final String NODE_EXT = "trcnxmi";
	public static final String AGENT_EXT = "trcaxmi";
	public static final String PROCESS_EXT = "trcpxmi";

	public static final String PROFILE_REFRESH_GROUP = "refreshGroup";
	public static final String PROFILE_MONITOR_GROUP = "monitoringGroup";
	public static final String PROFILE_ATTACH_GROUP = "attachGroup";
	public static final String PROFILE_NEW_SNAPSHOT_GROUP = "newSnapshotGroup";
	public static final String PROFILE_TERMINATE_GROUP = "terminateGroup";	
	public static final String PROFILE_GC_GROUP = "gcGroup";
	public static final String PROFILE_LAUNCH_GROUP = "launchGroup";

	public static final String LIMIT_TRACE_INVOC_OPTION = "limitInvoc";
	public static final String LIMIT_TRACE_TIME_OPTION = "limitTime";
	public static final String LIMIT_INVOC_NB = "invoc_nb";
	public static final String LIMIT_TIME_NB = "timeSec";
	public static final String COLLECT_DEPTH = "collect_depth";

	/**
	 * Different types of wizards using the Filters and Options page.
	 */
	public static final String ATTACH_LOCAL_WIZARD = "AttachLocalWizard";
	public static final String ATTACH_REMOTE_WIZARD = "AttachRemoteWizard";
	public static final String LAUNCH_LOCAL_WIZARD = "LaunchLocalWizard";
	public static final String LAUNCH_REMOTE_WIZARD = "LaunchRemoteWizard";
	public static final String RELAUNCH_WIZARD = "RelaunchWizard";
	
	public static final String DEFAULT_PROFILING_SET="org.eclipse.hyades.defaultProfilingSets.memory";
	
	public static final String DEFAULT_FILTER_SET = new StringBuffer("<filters>")
	.append("<filter name = '" + UIPlugin.getResourceString("STR_DEFAULT_SET_NAME") + "' enabled = 'true'>")
	.append("<contents>")
	.append("<content text = 'com.ibm*' method = '*' visibility='0'/>")
	.append("<content text = 'com.sun*' method = '*' visibility='0'/>")
	.append("<content text = 'COM.ibm*' method = '*' visibility='0'/>")	
	.append("<content text = 'java*' method = '*' visibility='0'/>")
	.append("<content text = 'org*' method = '*' visibility='0'/>")
	.append("<content text = 'sun*' method = '*' visibility='0'/>")
	.append("</contents>")
	.append("</filter>")
	.append("<filter name = '" + UIPlugin.getResourceString("J2EE_FILTER") + "' enabled = 'false'>")
	.append("<contents>")
	.append("<content text = 'com.ibm*' method = '*' visibility='0'/>")
	.append("<content text = 'com.tivoli*' method = '*' visibility='0'/>")
	.append("<content text = 'com.sun*' method = '*' visibility='0'/>")
	.append("<content text = 'COM.ibm*' method = '*' visibility='0'/>")
	.append("<content text = 'db2j*' method = '*' visibility='0'/>")
	.append("<content text = 'java*' method = '*' visibility='0'/>")
	.append("<content text = 'org*' method = '*' visibility='0'/>")
	.append("<content text = 'sun*' method = '*' visibility='0'/>")
	.append("</contents>")
	.append("</filter>")
	.append("<filter name = '" + UIPlugin.getResourceString("WEB_SPHERE_STD_FILTER") + "' enabled = 'false'>")
	.append("<contents>")
	.append("<content text = 'com.ibm*' method = '*' visibility='0'/>")
	.append("<content text = 'com.sun*' method = '*' visibility='0'/>")
	.append("<content text = 'COM.ibm*' method = '*' visibility='0'/>")
	.append("<content text = 'java*' method = '*' visibility='0'/>")
	.append("<content text = 'org.eclipse*' method = '*' visibility='0'/>")
	.append("<content text = 'sun*' method = '*' visibility='0'/>")
	.append("</contents>")
	.append("</filter>")
	.append("</filters>").toString();
}
