/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui;

import java.util.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.*;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class UIPlugin
	extends AbstractUIPlugin
    implements Application	
{
	protected static UIPlugin inst;
	protected ResourceBundle fResourceBundle;

    /**
     * 
     * @param descriptor
     */
	public UIPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		if (inst == null)
			inst = this;

		try {
			fResourceBundle = getDescriptor().getResourceBundle();
		} catch (MissingResourceException e) {
			e.printStackTrace();

		}
	}

	/**
	 * Adds an <code>ISelectionListener</code> to the trace selection manager.
	 */
	public void addSelectionListener(ISelectionListener l) {
		TraceUIManager.getTraceUIManager().addSelectionListener(l);
	}

	/**
	 * Remove an <code>ISelectionListener</code> to the trace selection manager.
	 */
	public void removeSelectionListener(ISelectionListener l) {
		TraceUIManager.getTraceUIManager().removeSelectionListener(l);
	}

	/**
	 * Adds the selection provider for the debug UI.
	 */
	public void addSelectionProvider(
		ISelectionProvider provider,
		IWorkbenchPart part) {
		TraceUIManager.getTraceUIManager().addSelectionProvider(provider, part);
	}

	/**
	 * Remove the console for this process
	 * @param process
	 */
 public void deregisterLaunchProcess(IProcess process) {
  TraceUIManager.getTraceUIManager().deregisterLaunchProcess(process);
 }
 
 /**
	 * Remove the console for this process
	 * @param process
	 */
public void deleteLaunch(IProcess process) {
TraceUIManager.getTraceUIManager().deleteLaunch(process);
}
 
 /**
  * adds the console for this process
  * @param process
  */
 public void registerLaunchProcess(IProcess process) {
  TraceUIManager.getTraceUIManager().registerLaunchProcess(process);
	}

	public static IWorkbenchPage getActivePage() {
		IWorkbenchPage page = getActiveWorkbenchWindow().getActivePage();

		if (page == null
			|| !page.getPerspective().getId().equals(
				PDPerspective.ID_TRACE_PERSPECTIVE)) {
			final IWorkbenchWindow dwindow = getActiveWorkbenchWindow();
			page = null;

			try {

				IWorkbenchPage[] persps = dwindow.getPages();
				for (int idx = 0; idx < persps.length; idx++) {
					if (persps[idx]
						.getPerspective()
						.getId()
						.equals(PDPerspective.ID_TRACE_PERSPECTIVE)) {
						//trace perspective
						page = persps[idx];

						dwindow.setActivePage(page);
						break;
					}
				}

				if (page == null) {
					IAdaptable element =
						UIPlugin.getPluginWorkbench().getRoot();
					IWorkbench workBench = dwindow.getWorkbench();
					if (workBench != null && element != null)
						page =
							workBench.showPerspective(
								PDPerspective.ID_TRACE_PERSPECTIVE,
								getActiveWorkbenchWindow(),
								element);
				}
			} catch (Exception exc) {
				exc.printStackTrace();
			}
		}

		return page;
	}
	public static Shell getActiveWorkbenchShell() {
		return getActiveWorkbenchWindow().getShell();
	}
	public static IWorkbenchWindow getActiveWorkbenchWindow() {
		return getDefault().getWorkbench().getActiveWorkbenchWindow();
	}


	public static UIPlugin getDefault() {
		return inst;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (2/16/2001 4:57:29 PM)
	 * @return com.ibm.jface.resource.ImageDescriptor
	 * @param name java.lang.String
	 */
	public static ImageDescriptor getImageDescriptor(String name) {
		return PDPluginImages.getImageDescriptor(name);
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (12/28/2000 1:05:55 PM)
	 * @return com.ibm.etools.perftrace.PerftraceFactory
	 */
	public HierarchyFactory getPerftraceFactory() {
		return TraceUIManager.getTraceUIManager().getPerftraceFactory();
	} /**
	 *
	 */
	public static String getPluginId() {
		return getDefault().getDescriptor().getUniqueIdentifier();
	}
	public static IWorkspace getPluginWorkbench() {
		return ResourcesPlugin.getWorkspace();
	}

    /**
     * 
     * @return ResourceBundle
     */
	public ResourceBundle getResourceBundle() {
		return fResourceBundle;
	}
	
	/**
	 * 
	 * @return ResourceSet
	 */
	public ResourceSet getResourceSet() {
		
		return TraceUIManager.getTraceUIManager().getResourceSet();
		
	}
	
	/**
	 * 
	 * @param key
	 * @return String
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = UIPlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * 
	 * @return PDProjectExplorer
	 */
	public PDProjectExplorer getViewer() {
		return PDProjectExplorer.getFromActivePerspective();
	}

	/**
	 * Sets default preference values. These values will be used
	 * until some preferences are actually set using Preference dialog.
	 */
	protected void initializeDefaultPreferences(IPreferenceStore store) {
		
		//hosts options
		store.setDefault(HyadesConstants.HOST_KEY, "localhost:10002");
		store.setDefault(HyadesConstants.LOCALHOST_PORT, "10002");
		
		//trace options
		store.setDefault(TraceConstants.TRACE_PROJECT_NAME, "ProfileProject");
		store.setDefault(TraceConstants.TRACE_MONITOR_NAME, "DefaultMonitor");
		store.setDefault(TraceConstants.LOG_OPTION_KEY, false);
		store.setDefault(TraceConstants.PROF_OPTION_KEY, true);
		store.setDefault(TraceConstants.PROFILE_TIPS, true);
		store.setDefault(TraceConstants.NEW_SNAPSHOT_TIPS,true);
		store.setDefault(TraceConstants.PROF_EXEC_STAT, true);
		store.setDefault(TraceConstants.PROF_HEAP_STAT, true);
		store.setDefault(TraceConstants.PROF_HEAP_INST, false);
		store.setDefault(TraceConstants.PROF_AUTO_MONITOR, true);
		store.setDefault(TraceConstants.REFRESH_TYPE, 0);
		store.setDefault(TraceConstants.REFRESH_INTERVAL, 3);

		String def = UIPlugin.getResourceString("STR_DEFAULT_SET_NAME");
		store.setDefault(TraceConstants.ACTIVE_FILTER_NAME, def);

		String filters = TraceConstants.DEFAULT_FILTER_SET;

		//default profiling options
		store.setDefault(TraceConstants.FILTERS_SET_KEY, filters);
		
		store.setDefault(TraceConstants.PROF_HEAP_SIZE, true);
		store.setDefault(TraceConstants.PROF_EXECUTION, false);
		store.setDefault(TraceConstants.PROF_EXECUTION_BOUNDARY, false);

		store.setDefault(TraceConstants.LIMIT_TRACE_INVOC_OPTION, false);
		store.setDefault(TraceConstants.LIMIT_TRACE_TIME_OPTION, false);
		store.setDefault(TraceConstants.LIMIT_INVOC_NB, "10000");
		store.setDefault(TraceConstants.LIMIT_TIME_NB, "5");
		store.setDefault(TraceConstants.COLLECT_DEPTH, "1");

	}
	


	/**
	 * Removes the selection provider from the debug UI.
	 */
	public void removeSelectionProvider(
		ISelectionProvider provider,
		IWorkbenchPart part) {
			
	    TraceUIManager.getTraceUIManager().removeSelectionProvider(provider, part);
	}
	
	/**
	 * Selection has changed in the debug selection provider.
	 * Notify the listeners.
	 */
	public void selectionChanged(SelectionChangedEvent event) {

		TraceUIManager.getTraceUIManager().selectionChanged(event);
	}
	/**
	 * @see ISelectionListener
	 */
	public void selectionChanged(IWorkbenchPart part, ISelection sel) {
  TraceUIManager.getTraceUIManager().selectionChanged(part, sel);
	}

    /**
     * Dispose all resources on this plugin shut down
     */
	public void shutdown() throws CoreException {
		super.shutdown();
		PDPluginImages.shutdown();
		
		TraceUIManager.getTraceUIManager().dispose();

		try {
			PDCoreUtil.detachAgents();
		} catch (Exception exc) {
			exc.printStackTrace();
			//do nothing
		}
		
		fResourceBundle = null;		
	}
	
	/**
	 * Starts up this plug-in and returns whether startup was successful.
	 *
	 */
	public void startup() throws CoreException {

//		TraceUIManager.getTraceUIManager().addSelectionListener(TraceUIManager.getTraceUIManager());

		super.startup();
	}
	/**
	 * Adds the given listener to the collection of registered profile
	 * event listeners. Has no effect if an identical listener is already
	 * registered.
	 *
	 * @param listener the listener to add
	 */
	public void addProfileEventListener(IProfileEventListener listener) {
		TraceUIManager.getTraceUIManager().addProfileEventListener(listener);
	}
	
	/**
	 * Removes the given listener from the collection of registered profile
	 * event listeners. Has no effect if an identical listener is not already
	 * registered.
	 *
	 * @param listener the listener to remove
	 */
	public void removeProfileEventListener(IProfileEventListener listener) {
		TraceUIManager.getTraceUIManager().removeProfileEventListener(listener);
	}

	
	/**
	 * Insert the method's description here.
	 * Creation date: (5/25/2001 3:24:32 PM)
	 * @param listener com.ibm.etools.pd.core.IDeleteListener
	 */
	public void addDeleteListener(IDeleteListener listener) {
		TraceUIManager.getTraceUIManager().addDeleteListener(listener);
	}


	/**
	 * Adds the given listener to the collection of registered pd view
	 * event listeners. Has no effect if an identical listener is already
	 * registered.
	 *
	 * @param listener the listener to add
	 */
	public void addViewSelectionChangedListener(IViewSelectionChangedListener listener) {
		TraceUIManager.getTraceUIManager().addViewSelectionChangedListener(listener);
	}


	/**
	 * 
	 * @param mofObject
	 * @param model
	 */
	public void addSelectionModel(EObject mofObject, ITraceSelection model) {
		TraceUIManager.getTraceUIManager().addSelectionModel(mofObject, model);
	}


	/**
	 * Insert the method's description here.
	 * Creation date: (5/25/2001 3:25:42 PM)
	 * @return java.util.ArrayList
	 */
	public ArrayList getDeleteListeners() {
		return TraceUIManager.getTraceUIManager().getDeleteListeners();
	}

	public ViewSelectionChangedEvent getViewSelectionChangedEvent() {
		return TraceUIManager.getTraceUIManager().getViewSelectionChangedEvent();
	}


	public ProfileEvent getProfileEvent() {
		return TraceUIManager.getTraceUIManager().getProfileEvent();
	}


	/**
	 * @return ProfileEvent
	 */
	public ProfileEvent getRefreshViewEvent(Object source) {
		return TraceUIManager.getTraceUIManager().getRefreshViewEvent(source);
	}


	/**
	 * 
	 * @param mofObject
	 * @return SelectionModel
	 */
	public ITraceSelection getSelectionModel(EObject mofObject) {

		return TraceUIManager.getTraceUIManager().getSelectionModel(mofObject);
	}


	/**
	 * @return ProfileEvent
	 */
	public ProfileEvent getUpdateModelEvent(Object source) {
		return TraceUIManager.getTraceUIManager().getUpdateModelEvent(source);
	}


	/**
	 * 
	 * @param event
	 */
	public void notifyViewSelectionChangedListener(ViewSelectionChangedEvent event) {
		
		TraceUIManager.getTraceUIManager().notifyViewSelectionChangedListener(event);
	}


	/**
	 * 
	 * @param event
	 */
	public void notifyProfileEventListener(ProfileEvent event) {
		
		TraceUIManager.getTraceUIManager().notifyProfileEventListener(event);
	}


	/**
	 * Insert the method's description here.
	 * Creation date: (10/03/2002 3:24:32 PM)
	 * @param listener com.ibm.etools.pd.core.IDeleteListener
	 */
	public void removeDeleteListener(IDeleteListener listener) {
		
		TraceUIManager.getTraceUIManager().removeDeleteListener(listener);
	}


	/**
	 * Removes the given listener from the collection of registered pd view
	 * event listeners. Has no effect if an identical listener is not already
	 * registered.
	 *
	 * @param listener the listener to remove
	 */
	public void removeViewSelectionChangedListener(IViewSelectionChangedListener listener) {
		TraceUIManager.getTraceUIManager().removeViewSelectionChangedListener(listener);
	}


	/**
	 * 
	 * @param mofObject
	 */
	public void removeSelectionModel(EObject mofObject) {
		TraceUIManager.getTraceUIManager().removeSelectionModel(mofObject);
	}

    /**
     * @see org.eclipse.hyades.internal.execution.local.control.Application.getName()
     */
	public String getName()
	{
		return getPluginId();
	}
	    
}
