/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.IPage;

/*
* CONTEXT_ID rfrv0000 for refresh views action
*/
public class RefreshViewsActionDelegate extends AbstractListenerActionDelegate {
	
	/**
	 * @see AbstractProfileActionDelegate#doAction(Object)
	 */
	public void doAction(Object object) throws Exception {
		INavigator fViewer = (INavigator)getView();
		if (fViewer == null) {
			MessageDialog.openInformation(
				UIPlugin.getActiveWorkbenchShell(),
				"title",
				"Action not available in current context");
			return;
		}

		TraceViewer viewer = getActiveViewer();
		if (viewer != null) {
			IPage page = viewer.getCurrentPage();
			if (page != null && page instanceof TraceViewerPage) {
				run(((TraceViewerPage)page).getMOFObject(), fViewer);
			}
		}
	}
		
	public void run(EObject object, INavigator fViewer) {
		ProfileEvent event = UIPlugin.getDefault().getUpdateModelEvent(object);
		UIPlugin.getDefault().notifyProfileEventListener(event);           
	}

	/**
	 * @see AbstractProfileActionDelegate#isEnabledFor(Object)
	 */
	protected boolean isEnabledFor(Object element) {

		if (element != null) {
			if (element instanceof EObject) {
				return true;
			}
			else if (element instanceof INavigatorItem) {
				return (((INavigatorItem)element).getData() instanceof EObject);				
			}
		}
		
		return false;
	}
	
	public void dispose()
	{
		super.dispose();
	}

	/*
	 * Returns the viewer that is currently visible, or null if
	 * there are no active viewers.
	 */
	private TraceViewer getActiveViewer() {
		IWorkbenchPage page = UIPlugin.getActivePage();
		IViewReference[] views = page.getViewReferences();
		for (int i=0;i<views.length;++i) {
			IViewPart view = views[i].getView(false);
			if (view instanceof TraceViewer && page.isPartVisible(view)) {
				return (TraceViewer)view;
			}
		}
		return null;
	}
}
