/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.JUnitLaunchConfiguration;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;

/*
 * NOTE: This class uses functionality that is internal to the PDE.
 * As soon as this functionality is made public, this class should
 * be modified accordingly. 
 */
public class ProfileJUnitPluginDelegate extends JUnitLaunchConfiguration {

	/*
	 * @see org.eclipse.jdt.internal.junit.launcher.JUnitBaseLaunchConfiguration#launch(org.eclipse.debug.core.ILaunchConfiguration, java.lang.String, org.eclipse.debug.core.ILaunch, org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
		try {
			monitor.beginTask("", 5);
			boolean success = ProfileJavaApplicationDelegate.performProfilingTypesLaunch(configuration);
			monitor.worked(1);
			
			if (!success) {
				monitor.setCanceled(true);
				return;
			}

			IJavaProject javaProject = getJavaProject(configuration);
			IType[] testTypes = getTestTypes(configuration, javaProject, null);
			
			IVMInstall launcher = LauncherUtils.createLauncher(configuration);
			monitor.worked(1);
	
			int port = SocketUtil.findFreePort();
			VMRunnerConfiguration runConfig = createVMRunner(configuration, testTypes, port, mode);
			if (runConfig == null) {
				monitor.setCanceled(true);
				return;
			} 
			
			String workspace = configuration.getAttribute(LOCATION + "0", getDefaultWorkspace(configuration));
			if (!LauncherUtils.clearWorkspace(configuration, workspace, new SubProgressMonitor(monitor, 1))) {
				monitor.setCanceled(true);
				return;
			}
	
			setDefaultSourceLocator(launch, configuration);
			launch.setAttribute(PORT_ATTR, Integer.toString(port));
			launch.setAttribute(TESTTYPE_ATTR, testTypes[0].getHandleIdentifier());
			PDEPlugin.getDefault().getLaunchesListener().manage(launch);
			monitor.worked(1);
			
			ProfilingSetsManager manager = ProfilingSetsManager.instance();
			IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
	
			TraceArguments args = new TraceArguments(runConfig.getClassToLaunch());
			args.setClassPath(generateString(runConfig.getClassPath(), File.pathSeparatorChar));
			args.setParameters(generateString(runConfig.getProgramArguments(), ' '));
			args.setVMArguments(generateString(runConfig.getVMArguments(), ' '));
			args.setEnvironmentVariable(manager.getEnvironmentVariables(configuration));
			args.setAutoMonitoring(manager.getAutoMonitoring(configuration));
			args.setLocation(runConfig.getWorkingDirectory());
			
			String hostName = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
			port = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getInt(HyadesConstants.LOCALHOST_PORT));
			String projectName = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString(TraceConstants.TRACE_PROJECT_NAME));
			String monitorName = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString(TraceConstants.TRACE_MONITOR_NAME));
	
			args.setHostName(hostName);
			args.setPortNumber(port);
	
			if (configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false))
				args.setProfileFile(configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String)null));
	
			ArrayList filters = manager.getFilters(configuration);
			Vector options = manager.getOptions(configuration);
			monitor.worked(1);
			
			PDCoreUtil.launchTrace(args, filters, options, projectName, monitorName, launch);
			monitor.worked(1);
		}
		catch (CoreException e) {
			monitor.setCanceled(true);
			throw e;
		}
	}
	
	/*
	 * Converts an array of Strings to a delimiter-separated String.
	 */
	private static String generateString(String[] array, char delimiter) {
		StringBuffer buf = new StringBuffer();
		if (array.length > 0) {
			for (int i=0;i<array.length-1;++i) {
				buf.append(array[i]);
				buf.append(delimiter);
			}
			buf.append(array[array.length-1]);
		}
		return buf.toString();
	}

	/*
	 * Copied verbatim from the PDE equivalent delegate.
	 */
	private String getDefaultWorkspace(ILaunchConfiguration config) throws CoreException {
		if (config.getAttribute(APPLICATION, UI_APPLICATION).equals(UI_APPLICATION))
			return LauncherUtils.getDefaultPath().append("junit-workbench-workspace").toOSString();
		return LauncherUtils.getDefaultPath().append("junit-core-workspace").toOSString();				
	}
}
