/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.edit.datapool;

/**
 * An element of a {@link IDatapoolRecord record} within a datapool.  Each
 * cell contains a reference to the {@link IDatapoolVariable variable} that 
 * it is referenced by along with the actual value the cell represents.
 * There are a series of convienence methods for accessing the associated 
 * value as a specific type, such as a <code>String</code> or an <code>int</code>.
 * 
 */
public interface IDatapoolCell extends
	org.eclipse.hyades.execution.runtime.datapool.IDatapoolCell
{
	
	/**
	 * Defines the {@link IDatapoolVariable variable} that is used to reference
	 * this cell within a {@link IDatapoolRecord record}.
	 * 
	 * @param	variable	The {@link IDatapoolVariable variable} will be used to reference
	 *			this cell within a {@link IDatapoolRecord record}.
	 */
	public void setVariable(IDatapoolVariable variable);
	
	/**
	 * Replace the unprocessed persisted string representation.
	 * 
	 * @param	value		The value to be associated with this cell.
	 * 
	 * @see #getRawValue()
	 */
	public void setPersistedRepresentation(String value);
	
	/**
	 * The unprocessed string representation of the cell is returned.
	 * 
	 * @return	The unprocessed string representation of the cell.
	 * 
	 * @see #setRawValue()
	 */
	public String getPersistedRepresentation();
	

	/**
	 * Replace the value associated with the cell.
	 * 
	 * @param	value		The value to be associated with this cell.
	 * 
	 * @see #getCellValue()
	 */	
	public void setCellValue(Object value);
	
	/**
	 * Clones the value associated with the cell.
	 *
	 * @return  A exact duplicate of the value.
	 */
	public Object getClonedCellValue();
}
