/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.testgen.http;

// import java.util.HashMap;

import org.eclipse.hyades.internal.execution.testgen.TestgenException;
// mdd for Hyades-O 1.2
import java.util.LinkedList;

/**
 * @author dhinson
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class TRCPacketNodeHandler extends TRCNodeHandler implements ITRCNodeHandler
{

	private static final String	PACKET_A_TYPE
														= "type";
	private static final String	PACKET_A_TYPE_V_HTTP
														= "HTTP";
	private static final String	PACKET_A_TYPE_V_HTTPS
														= "HTTPS";

	
	// name of global last receive timestamp
	private static final String GLOBAL_LASTRECV	= "__global";
	private TestGenHttp thisHttp;
	
	// private ParsedHttpMessage	currentHttpRequest;

	public void init (TRCContext context)
		throws TestgenException
	{
		super.init(context);
		
		// mdd new
		thisHttp = new TestGenHttp(context);
		LinkedList myPageList = context.getPageList();
		myPageList.clear();
		context.setPageList(myPageList);
	}
	
	public void node (TRCNode node)
		throws TestgenException
	{
		LinkedList myPageList;
		// dispatch on type attribute
		String typeValue = getAttributeValue(PACKET_A_TYPE, node);		
		if ((!typeValue.equals(PACKET_A_TYPE_V_HTTP))&& (!typeValue.equals(PACKET_A_TYPE_V_HTTPS)) )
			// currently ignore anything but "HTTP"
			return;
		myPageList = context.getPageList();
		myPageList.add(node);
		context.setPageList(myPageList);
		// Http Specific Call below
		// Skip this call to handle_node() mdd 11/24/2003
		//thisHttp.handle_node(node);
		return;
	}
		

}
