/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.context.Component;
import org.eclipse.hyades.logging.adapter.model.internal.context.RoleNames;
import org.eclipse.hyades.logging.adapter.model.internal.context.provider.ComponentItemProvider;
import org.eclipse.hyades.logging.adapter.model.internal.context.provider.ContextItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorType;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ComponentSection extends Composite
								implements IDetails, ModifyListener, SelectionListener
										   , INotifyChangedListener
{
	protected Text descriptionText;			
	protected Text execClassText;
	protected Text uniqueIDText;
	protected Text impDateText;			
	protected Text impVersionText;			
	protected Text impVDescrText;			
	protected Text logLevelText;			
	protected Text nameText;			
	protected CCombo roleCombo;
	protected Text roleDateText;			
	protected Text roleVersionText;			
	protected Text roleVDescrText;	
	protected Button browseRef;		
				
	protected EditingDomain editingDomain;				
    protected boolean isDisplaying;
    protected Component currentSelection;
    protected ComponentItemProvider itemProvider;
    protected ContextItemProviderAdapterFactory itemFactory;
	
	
	public ComponentSection(RuleBuilderWidgetFactory factory, EditingDomain editingDomain, Composite composite, int style){

		super(composite, style);
		
		this.itemFactory = new ContextItemProviderAdapterFactory();
		this.editingDomain = editingDomain;

		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		detailLayout.verticalSpacing = 5;

		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());

		Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_COMP_NAME"), SWT.NONE);	
		nameText = factory.createText(this, "", SWT.NULL);
		nameText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		

		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_COMP_DESCR"), SWT.NONE);	
		descriptionText = factory.createText(this, "", SWT.NULL);
		descriptionText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		

		label = factory.createLabel(this, "", SWT.NONE);	
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		
		
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_COMP_EXECC"), SWT.NONE);	
		execClassText = factory.createText(this, "", SWT.MULTI);
		execClassText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	

		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_COMP_IMPLCD"), SWT.NONE);	
	    impDateText = factory.createText(this, "", SWT.NULL);
		impDateText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	

		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_COMP_IMPLV"), SWT.NONE);	
		impVersionText = factory.createText(this, "", SWT.NULL);
		impVersionText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	
		
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_COMP_IMPLVD"), SWT.NONE);	
		impVDescrText = factory.createText(this, "", SWT.NULL);
		impVDescrText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	
			
		label = factory.createLabel(this, "", SWT.NONE);	
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		

		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_COMP_LOGL"), SWT.NONE);	
		logLevelText = factory.createText(this, "", SWT.NULL);
		logLevelText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	
	
		label = factory.createLabel(this, "", SWT.NONE);	
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		

		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_COMP_ROLE"), SWT.NONE);	
		roleCombo = factory.createCombo(this, SWT.READ_ONLY);
		roleCombo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		initializeRoleCombo();	
		        
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_COMP_ROLECD"), SWT.NONE);	
		roleDateText = factory.createText(this, "", SWT.NULL);
		roleDateText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	

		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_COMP_ROLEV"), SWT.NONE);	
		roleVersionText = factory.createText(this, "", SWT.NULL);
		roleVersionText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	

		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_COMP_ROLEVD"), SWT.NONE);	
		roleVDescrText = factory.createText(this, "", SWT.NULL);
		roleVDescrText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	
				
		label = factory.createLabel(this, "", SWT.NONE);	
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		

        Composite refGroup = factory.createComposite(this);	
		detailLayout = new GridLayout();
		detailLayout.numColumns = 3;
		detailLayout.verticalSpacing = 5;
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;
		refGroup.setLayoutData(data);
		refGroup.setLayout(detailLayout);

		label = factory.createLabel(refGroup, AcadEditorPlugin.getPlugin().getString("STR_COMP_ID"), SWT.NONE);	
		uniqueIDText = factory.createText(refGroup, "", SWT.NULL);
		uniqueIDText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		uniqueIDText.setEditable(false);	
		browseRef = factory.createButton(refGroup, AcadEditorPlugin.getPlugin().getString("BROWSE"), SWT.PUSH);	
		
		// add listeners - don't change the order in which the listeners are added
		// because of team support issues modify listeners should always be the last one added
		descriptionText.addModifyListener(this);
		nameText.addModifyListener(this);
		execClassText.addModifyListener(this);
		uniqueIDText.addModifyListener(this);
		impDateText.addModifyListener(this);
		impVDescrText.addModifyListener(this);
		impVersionText.addModifyListener(this);
		logLevelText.addModifyListener(this);
		roleDateText.addModifyListener(this);
		roleCombo.addSelectionListener(this);
		roleVDescrText.addModifyListener(this);
		roleVersionText.addModifyListener(this);
		browseRef.addSelectionListener(this);
		
		itemProvider = (ComponentItemProvider)itemFactory.createComponentAdapter();
		itemProvider.addListener(this);
	}
	
	protected void initializeRoleCombo()
	{
		roleCombo.add("Sensor");
		roleCombo.add("Extractor");
		roleCombo.add("Parser");
		roleCombo.add("Formatter");
		roleCombo.add("Message Filter");
		roleCombo.add("CBE Filter");
		roleCombo.add("Outputter");
		roleCombo.add("undeclared");				
	}
	
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {
      
		if(currentSelection == object)
		  return;

		if(descriptionText.isFocusControl() || execClassText.isFocusControl()
		   || uniqueIDText.isFocusControl() || logLevelText.isFocusControl()
		   || impDateText.isFocusControl() || impVDescrText.isFocusControl()
		   || impVersionText.isFocusControl() || nameText.isFocusControl()
		   || roleDateText.isFocusControl() || roleCombo.isFocusControl()
		   || roleVDescrText.isFocusControl() || roleVersionText.isFocusControl())
		   
		  return;
        
		currentSelection = (Component)object;
		isDisplaying = true;
			
		descriptionText.setText(currentSelection.getDescription()==null?"":currentSelection.getDescription());
		execClassText.setText(currentSelection.getExecutableClass()==null?"":currentSelection.getExecutableClass());
		uniqueIDText.setText(currentSelection.getUniqueID()==null?"":currentSelection.getUniqueID());
		nameText.setText(currentSelection.getName()==null?"":currentSelection.getName());
		logLevelText.setText(currentSelection.getLoggingLevel()==null?"":currentSelection.getLoggingLevel());
		impDateText.setText(currentSelection.getImplementationCreationDate()==null?"":currentSelection.getImplementationCreationDate().toString());
		impVDescrText.setText(currentSelection.getImplementationVersionDescription()==null?"":currentSelection.getImplementationVersionDescription());
		impVersionText.setText(currentSelection.getImplementationVersion()==null?"":currentSelection.getImplementationVersion());
		roleDateText.setText(currentSelection.getRoleCreationDate()==null?"":currentSelection.getRoleCreationDate().toString());
		roleVDescrText.setText(currentSelection.getRoleVersionDescription()==null?"":currentSelection.getRoleVersionDescription());
		roleVersionText.setText(currentSelection.getRoleVersion()==null?"":currentSelection.getRoleVersion());
		
		roleCombo.select(currentSelection.getRole().getValue());
		
		isDisplaying = false;
	}

	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {

 		this.currentSelection = (Component)currentSelection;
		
		this.currentSelection.setDescription(descriptionText.getText());
		this.currentSelection.setExecutableClass(execClassText.getText());
		this.currentSelection.setUniqueID(uniqueIDText.getText());
		this.currentSelection.setName(nameText.getText());
		this.currentSelection.setLoggingLevel(logLevelText.getText());
		this.currentSelection.setImplementationCreationDate(impDateText.getText());
		this.currentSelection.setImplementationVersion(impVersionText.getText());
		this.currentSelection.setImplementationVersionDescription(impVDescrText.getText());
		this.currentSelection.setRoleCreationDate(roleDateText.getText());
		this.currentSelection.setRoleVersion(roleVersionText.getText());
		this.currentSelection.setRoleVersionDescription(roleVDescrText.getText());
		
		this.currentSelection.setRole(RoleNames.get(roleCombo.getSelectionIndex()));
		
		
		return false;

	}
	
	public void setFocusToText(){
	        nameText.setFocus();
	        nameText.selectAll();
	}

	/**
	 * Sent when the text is modified.
	 *
	 * @param e an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e)
	{
		
		if(isDisplaying || currentSelection == null)
		  return;
		  
		if(e.getSource() == descriptionText)
		{
			String text = descriptionText.getText();
			if(!text.equals(currentSelection.getDescription()))
			{
				if(text.length() == 0 && currentSelection.getDescription() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
				ComponentItemProvider.DESCRIPTION);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
		else if(e.getSource() == execClassText)
		{
			String text = execClassText.getText();
			if(!text.equals(currentSelection.getExecutableClass()))
			{
				if(text.length() == 0 && currentSelection.getExecutableClass() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ComponentItemProvider.EXEC_CLASS);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
		else if(e.getSource() == nameText)
		{
			String text = nameText.getText();
			if(!text.equals(currentSelection.getName()))
			{
				if(text.length() == 0 && currentSelection.getName() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
				ComponentItemProvider.NAME);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
		else if(e.getSource() == logLevelText)
		{
			String text = logLevelText.getText();
			if(!text.equals(currentSelection.getLoggingLevel()))
			{
				if(text.length() == 0 && currentSelection.getLoggingLevel() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
				ComponentItemProvider.LOG_LEVEL);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
		else if(e.getSource() == impDateText)
		{
			String text = impDateText.getText();
			if(!text.equals(currentSelection.getImplementationCreationDate()))
			{
				if(text.length() == 0 && currentSelection.getImplementationCreationDate() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ComponentItemProvider.IMPL_DATE);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
		else if(e.getSource() == impVDescrText)
		{
			String text = impVDescrText.getText();
			if(!text.equals(currentSelection.getImplementationVersionDescription()))
			{
				if(text.length() == 0 && currentSelection.getImplementationVersionDescription() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ComponentItemProvider.IMPL_DESCR);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
		else if(e.getSource() == impVersionText)
		{
			String text = impVersionText.getText();
			if(!text.equals(currentSelection.getImplementationVersion()))
			{
				if(text.length() == 0 && currentSelection.getImplementationVersion() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ComponentItemProvider.IMPL_VERSION);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
		else if(e.getSource() == roleDateText)
		{
			String text = roleDateText.getText();
			if(!text.equals(currentSelection.getRoleCreationDate()))
			{
				if(text.length() == 0 && currentSelection.getRoleCreationDate() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ComponentItemProvider.ROLE_DATE);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
		else if(e.getSource() == roleVDescrText)
		{
			String text = roleVDescrText.getText();
			if(!text.equals(currentSelection.getRoleVersionDescription()))
			{
				if(text.length() == 0 && currentSelection.getRoleVersionDescription() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ComponentItemProvider.ROLE_DESC);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
		else if(e.getSource() == roleVersionText)
		{
			String text = roleVersionText.getText();
			if(!text.equals(currentSelection.getRoleVersion()))
			{
				if(text.length() == 0 && currentSelection.getRoleVersion() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ComponentItemProvider.ROLE_VERSION);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
		else if(e.getSource() == uniqueIDText)
		{
			String text = uniqueIDText.getText();
			if(!text.equals(currentSelection.getUniqueID()))
			{
				if(text.length() == 0 && currentSelection.getUniqueID() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ComponentItemProvider.UNIQUE_ID);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}			
		}
		
		
	}

	public void dispose() {
		
		itemFactory = null;
		itemProvider = null;
		editingDomain = null;
		currentSelection = null;
	}

	/**
	 */
	public void notifyChanged(Notification notification)
	{
		Object obj = notification.getNotifier();
		
		if(obj == null || (obj != currentSelection))
		  return;
		  
		display(currentSelection);
	}

	public void widgetDefaultSelected(SelectionEvent e)
	{
	}

	public void widgetSelected(SelectionEvent e)
	{
		if(e.getSource() == roleCombo)
		{
			int sel = roleCombo.getSelectionIndex();
			if(sel != currentSelection.getRole().getValue())
			{
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ComponentItemProvider.NAME);
				
                currentSelection.setRole(RoleNames.get(sel));				
				String oldValue = currentSelection.getName();		
				if(descriptor != null)
				{
					descriptor.setPropertyValue(currentSelection, oldValue);										
				}	
			}			
			
		}
		else if(e.getSource() == browseRef)
		{
			ResourceSelectionDialog dialog = new ResourceSelectionDialog(Display.getCurrent().getActiveShell(), editingDomain);
			dialog.open();
			
			if(dialog.getReturnCode() == Window.OK)
			{
				Object sel = dialog.getSelection();
				if(sel != null)
				{
					if(sel instanceof SensorConfigType)
					  uniqueIDText.setText(((SensorConfigType)sel).getUniqueID());
					else if(sel instanceof ExtractorType)
					  uniqueIDText.setText(((ExtractorType)sel).getUniqueID());	
					else if(sel instanceof OutputterConfigType)
					  uniqueIDText.setText(((OutputterConfigType)sel).getUniqueID());					  
					else if(sel instanceof ContextInstanceType)
					  uniqueIDText.setText(((ContextInstanceType)sel).getUniqueID());
					else if(sel instanceof ProcessUnitType)
					  uniqueIDText.setText(((ProcessUnitType)sel).getUniqueID());	
					else if(sel instanceof ParserConfigType)
					  uniqueIDText.setText(((ParserConfigType)sel).getUniqueID());					  
					else if(sel instanceof FormatterType)
					  uniqueIDText.setText(((FormatterType)sel).getUniqueID());					  


					else
					  uniqueIDText.setText("");  
					
				}
			}
		}
	}

}
