/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.io.File;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.AbstractListenerActionDelegate;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class StartTraceActionDelegate
extends AbstractListenerActionDelegate {
    public void doAction(Object object) throws Exception {
        if (object == null || !(object instanceof TRCAgentProxy)) {
            return;
        }
        INavigator fViewer = (INavigator)this.getView();
        if (fViewer == null) {
            MessageDialog.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)"title", (String)"Action not available in current context");
            return;
        }
        this.run((TRCAgentProxy)object, fViewer);
    }

    public void run(TRCAgentProxy agent, INavigator fViewer) {
        TRCProcessProxy process = agent.getProcessProxy();
        String host = process.getNode().getName();
        try {
            Agent a;
            Node node = PDCoreUtil.profileConnect(host, String.valueOf(process.getNode().getPort()));
            if (node == null) {
                return;
            }
            Object instance = LoadersUtils.locateAgentInstance((TRCAgentProxy)agent);
            if (instance != null && instance instanceof Agent && (a = (Agent)instance).isActive()) {
                if (agent.isToProfileFile()) {
                    a.setProfileFile(agent.getProfileFile());
                } else {
                    a.setProfileFile(null);
                }
                PDCoreUtil.setAgentConfiguration(agent, a);
                a.publishConfiguration();
                CustomCommand command = new CustomCommand();
                command.setData("APPLYFILTERS");
                a.invokeCustomCommand(command);
                XMLTraceDataProcessor processor = (XMLTraceDataProcessor)LoadersUtils.locateDataProcessor((TRCAgentProxy)agent);
                if (processor == null) {
                    processor = new XMLTraceDataProcessor(agent);
                    LoadersUtils.registerDataProcessor((TRCAgentProxy)agent, (XMLLoader)processor);
                }
                if (processor != null) {
                    File testFile;
                    String processorProfileFileName = processor.getProfileFileName();
                    File processorProfilingFile = processorProfileFileName == null ? null : new File(processorProfileFileName);
                    boolean newFile = true;
                    if (agent.isToProfileFile() && (testFile = new File(agent.getProfileFile())).exists()) {
                        newFile = false;
                    }
                    if (processorProfilingFile == null && agent.isToProfileFile()) {
                        processor.setProfileFileName(agent.getProfileFile());
                        processor.createWriter();
                        newFile = processor.isNewProfileFile();
                        if (newFile) {
                            processor.writeXMLVersion(processor.getWriter());
                            processor.startTrace(processor.getWriter());
                        }
                    } else if (!(processorProfileFileName == null || processorProfileFileName.equals(agent.getProfileFile()) && processorProfilingFile.exists())) {
                        if (processorProfilingFile.exists()) {
                            processor.endTrace(processor.getWriter());
                        }
                        processor.setProfileFileName(agent.getProfileFile());
                        processor.createWriter();
                        newFile = processor.isNewProfileFile();
                        if (newFile) {
                            processor.writeXMLVersion(processor.getWriter());
                            processor.startTrace(processor.getWriter());
                        }
                    }
                }
                a.startMonitoring((DataProcessor)processor);
                agent.setCollectionData(true);
                command.setData("RESUME");
                a.invokeCustomCommand(command);
                agent.setMonitored(true);
                agent.setActive(true);
                agent.setAttached(true);
                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource(agent);
                event.setType(1);
                UIPlugin.getDefault().notifyProfileEventListener(event);
            }
            fViewer.getViewer().refresh((Object)agent);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    protected boolean isEnabledFor(Object element) {
        return element != null && element instanceof TRCAgentProxy && ((TRCAgentProxy)element).isAttached() && !((TRCAgentProxy)element).isMonitored();
    }

    public void dispose() {
        super.dispose();
    }
}

