/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.navigator;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.navigator.LogContentProvider;
import org.eclipse.hyades.log.ui.internal.navigator.LogLabelProvider;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigatorActionGroup;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigatorSynchronizer;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.provider.ResourceChangeUpdaterProvider;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LogNavigator
extends TreeNavigator
implements IProfileEventListener,
IPropertyListener {
    public static final String ID = "org.eclipse.hyades.log.ui.logNavigator";
    private final String LOG_SECTION = "LogNavigator";
    private LogContentProvider contentProvider;
    private ResourceChangeUpdaterProvider resourceChangeUpdaterProvider;
    private LogNavigatorSynchronizer synchronizer;
    private int fFilterProperties;

    public LogNavigator() {
        super(ID);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        TraceAssociationManager.getTraceViewMappingRegistry().addCommitChangeListener((IPropertyListener)this);
        UIPlugin.getDefault().addSelectionProvider((ISelectionProvider)this.getViewer(), (IWorkbenchPart)this);
        UIPlugin.getDefault().addProfileEventListener((IProfileEventListener)this);
    }

    public void dispose() {
        TraceAssociationManager.getTraceViewMappingRegistry().removeCommitChangeListener((IPropertyListener)this);
        UIPlugin.getDefault().removeSelectionProvider((ISelectionProvider)this.getViewer(), (IWorkbenchPart)this);
        UIPlugin.getDefault().removeProfileEventListener((IProfileEventListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeUpdaterProvider);
        this.resourceChangeUpdaterProvider.dispose();
        this.resourceChangeUpdaterProvider = null;
        this.contentProvider.getResourceSet().eAdapters().remove((Object)this.synchronizer);
        this.synchronizer.dispose();
        this.synchronizer = null;
        this.contentProvider.dispose();
        this.contentProvider = null;
        HyadesUtil.cleanupResources((String)"org.eclipse.hyades.log.ui.internal.navigator.LogNavigator");
        super.dispose();
    }

    public AbstractUIPlugin getPlugin() {
        return LogUIPlugin.getDefault();
    }

    public boolean isShowingFolders() {
        return false;
    }

    public void handleProfileEvent(ProfileEvent event) {
        if (event.getSource() != null && (event.getSource() instanceof TRCAgentProxy && ((TRCAgentProxy)event.getSource()).getType().equals("Logging") || event.getSource() instanceof IWorkspaceRoot)) {
            switch (event.getType()) {
                case 1: {
                    this.getViewer().setSelection((ISelection)new StructuredSelection(event.getSource()));
                    this.getViewer().update(event.getSource(), null);
                    break;
                }
                case 4: {
                    this.getViewer().setSelection((ISelection)new StructuredSelection(event.getSource()));
                    break;
                }
                case 4096: {
                    break;
                }
                case 4608: {
                    this.getContentProvider().refreshFromLocal();
                    break;
                }
                case 5120: {
                    break;
                }
                default: {
                    this.getViewer().refresh(event.getSource());
                }
            }
        }
    }

    protected void createActions() {
        this.setActionGroup((NavigatorActionGroup)new LogNavigatorActionGroup(this));
    }

    protected Object createViewerInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected boolean editorActivated(IEditorPart editor) {
        return false;
    }

    public String getStoreSection() {
        return "LogNavigator";
    }

    protected void linkToEditor(IStructuredSelection selection) {
    }

    public void doubleClick(DoubleClickEvent event) {
        if (event.getViewer() == this.getTreeViewer()) {
            ((LogNavigatorActionGroup)this.getActionGroup()).handleDoubleClick(event);
        }
    }

    public LogContentProvider getContentProvider() {
        return this.contentProvider;
    }

    protected void adjustTreeViewer(TreeViewer treeViewer) {
        this.contentProvider = new LogContentProvider(this);
        treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)new LogLabelProvider());
        this.resourceChangeUpdaterProvider = new ResourceChangeUpdaterProvider.UIUpdaterProvider();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeUpdaterProvider, 1);
        this.synchronizer = new LogNavigatorSynchronizer(this);
        this.synchronizer.register(this.resourceChangeUpdaterProvider, this.contentProvider.getResourceSet());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void setLinkingEnabled(boolean enabled) {
        super.setLinkingEnabled(enabled);
        if (enabled && this.getViewer() != null) {
            this.getViewer().setSelection(this.getViewer().getSelection());
        }
    }

    protected void initContextMenu() {
        MenuManager menuMgr = new MenuManager("#LogNavigatorPopupMenu#");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = menuMgr.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.getViewer());
    }

    public void partActivated(IWorkbenchPart part) {
        super.partActivated(part);
        if (part == this) {
            this.getViewer().setSelection((ISelection)((LogNavigator)part).getStructuredSelection());
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        super.partBroughtToTop(part);
        if (part == this) {
            this.getViewer().setSelection((ISelection)((LogNavigator)part).getStructuredSelection());
        }
    }

    protected String getHelpContextId() {
        return ContextIds.LOG_NAVIGATOR_VIEW;
    }

    public IDialogSettings getSettings() {
        return super.getSettings();
    }

    public void propertyChanged(Object source, int propId) {
        ((LogNavigatorActionGroup)this.getActionGroup()).propertyChanged(source, propId);
    }
}

