/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.IImportWizardWidget;
import org.eclipse.hyades.log.ui.internal.wizards.ParserField;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ImportWizardTextArea
implements IImportWizardWidget {
    protected Text text;
    private ParserField _field = null;

    public ImportWizardTextArea(ParserField field) {
        this._field = field;
    }

    public String getValue() {
        return this.text.getText().trim();
    }

    public void setValue(String newValue) {
        this.text.setText(newValue);
    }

    public void createControl(Composite composite, String prefix) {
        Label label = new Label(composite, 64);
        GridData data = new GridData();
        data.widthHint = 400;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(this._field.getName());
        this.text = new Text(composite, 2818);
        data = new GridData();
        data.widthHint = 400;
        data.horizontalSpan = 2;
        data.heightHint = 40;
        this.text.setLayoutData((Object)data);
        this.text.setToolTipText(this._field.getTooltip());
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
        String previousValue = store.getString(prefix + this._field.getId());
        if (previousValue != null && !previousValue.equals("")) {
            this.text.setText(previousValue);
        } else {
            this.text.setText(this._field.getDefaultValue());
        }
    }

    public boolean isValid() {
        return !this.text.getVisible() || !this.text.getText().trim().equals("");
    }

    public Text getText() {
        return this.text;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public ParserField getField() {
        return this._field;
    }
}

