/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.manual.runner.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.hyades.test.common.util.XMLUtil;
import org.eclipse.hyades.test.manual.runner.model.Action;
import org.eclipse.hyades.test.manual.runner.model.IActionOwner;
import org.eclipse.hyades.test.manual.runner.model.Loop;
import org.eclipse.hyades.test.manual.runner.model.NamedElement;
import org.eclipse.hyades.test.manual.runner.model.Test;
import org.eclipse.hyades.test.manual.runner.model.TestCase;
import org.eclipse.hyades.test.manual.runner.model.TestInvocation;
import org.eclipse.hyades.test.manual.runner.model.TestSuite;
import org.eclipse.hyades.test.manual.runner.model.util.Verdict;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScriptParser {
    private Map namedElementById;
    private List verdicts;
    private Map elementByTestSuite;
    private TestSuite root;
    private List testInvocations;
    private int executionId;

    public void dispose() {
        if (this.namedElementById != null) {
            this.namedElementById.clear();
            this.namedElementById = null;
        }
        if (this.verdicts != null) {
            this.verdicts.clear();
            this.verdicts = null;
        }
        if (this.elementByTestSuite != null) {
            this.elementByTestSuite.clear();
            this.elementByTestSuite = null;
        }
        if (this.testInvocations != null) {
            this.testInvocations.clear();
            this.testInvocations = null;
        }
        this.root = null;
    }

    public TestSuite parse(byte[] byArray) throws Exception {
        Element element = XMLUtil.loadDom((String)new String(byArray, "UTF-8"), (String)"testScript");
        if (element != null) {
            Element element2;
            int n;
            NodeList nodeList = XMLUtil.getChildrenByName((Element)element, (String)"verdicts");
            if (nodeList != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    if (!(nodeList.item(n) instanceof Element) || (element2 = (Element)nodeList.item(n)) == null) continue;
                    this.verdicts = new ArrayList();
                    this.parseVerdicts(element2);
                    break;
                }
            }
            if ((nodeList = XMLUtil.getChildrenByName((Element)element, (String)"testSuite")) != null) {
                for (n = 0; n < nodeList.getLength(); ++n) {
                    if (!(nodeList.item(n) instanceof Element) || (element2 = (Element)nodeList.item(n)) == null) continue;
                    this.root = new TestSuite();
                    this.root.setExecutionId(0);
                    this.namedElementById = new HashMap();
                    this.elementByTestSuite = new HashMap();
                    this.testInvocations = Collections.EMPTY_LIST;
                    this.parse(this.root, element2);
                    this.adjust(this.root);
                    this.testInvocations = this.getTestInvocations(this.root);
                    break;
                }
            }
        }
        return this.root;
    }

    public List getTestInvocations() {
        return this.testInvocations;
    }

    private List getTestInvocations(IActionOwner iActionOwner) {
        int n = this.executionId;
        ArrayList<TestInvocation> arrayList = new ArrayList<TestInvocation>();
        Object object = iActionOwner.getActions().iterator();
        while (object.hasNext()) {
            Action action = (Action)object.next();
            action.setExecutionId(this.executionId);
            if (action.isSynchronous()) {
                ++this.executionId;
            }
            if (action instanceof IActionOwner) {
                arrayList.addAll(this.getTestInvocations((IActionOwner)((Object)action)));
                continue;
            }
            if (!(action instanceof TestInvocation)) continue;
            TestInvocation testInvocation = (TestInvocation)action;
            arrayList.add(testInvocation);
            if (testInvocation.getTest() == null || !(testInvocation.getTest() instanceof IActionOwner)) continue;
            testInvocation.getTest().setExecutionId(testInvocation.getExecutionId());
            arrayList.addAll(this.getTestInvocations((IActionOwner)((Object)testInvocation.getTest())));
        }
        if (iActionOwner instanceof Action) {
            if (!((Action)((Object)iActionOwner)).isSynchronous()) {
                this.executionId = n;
            }
        } else if (iActionOwner instanceof TestSuite && (object = ((TestSuite)iActionOwner).getTestInvocation()) != null && !((Action)object).isSynchronous()) {
            this.executionId = n;
        }
        return arrayList;
    }

    public List getVerdics() {
        if (this.verdicts == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(this.verdicts);
    }

    protected void adjust(IActionOwner iActionOwner) {
        Iterator iterator = iActionOwner.getActions().iterator();
        while (iterator.hasNext()) {
            TestInvocation testInvocation;
            Action action = (Action)iterator.next();
            if (action instanceof IActionOwner) {
                this.adjust((IActionOwner)((Object)action));
                continue;
            }
            if (!(action instanceof TestInvocation) || (testInvocation = (TestInvocation)action).getTestId() == null || testInvocation.getTest() != null) continue;
            Object v = this.namedElementById.get(testInvocation.getTestId());
            if (v instanceof TestCase) {
                testInvocation.setTest((Test)v);
            } else {
                if (!(v instanceof TestSuite)) continue;
                TestSuite testSuite = new TestSuite();
                testInvocation.setTest(testSuite);
                testSuite.setTestInvocation(testInvocation);
                this.parse(testSuite, (Element)this.elementByTestSuite.get(v));
                this.adjust(testSuite);
            }
            if (testInvocation.getTest().getDescription() == null) continue;
            if (testInvocation.getDescription() != null) {
                testInvocation.setDescription(testInvocation.getTest().getDescription() + "\n\n" + testInvocation.getDescription());
                continue;
            }
            testInvocation.setDescription(testInvocation.getTest().getDescription());
        }
    }

    protected void parseVerdicts(Element element) {
        NodeList nodeList = XMLUtil.getChildrenByName((Element)element, (String)"verdict");
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                try {
                    this.verdicts.add(new Verdict(XMLUtil.getValue((Element)element2, (String)"label"), Integer.parseInt(XMLUtil.getValue((Element)element2, (String)"value")), new Boolean(XMLUtil.getValue((Element)element2, (String)"isDefault"))));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    protected void parse(TestSuite testSuite, Element element) {
        NodeList nodeList;
        Test test;
        int n;
        int n2;
        NodeList nodeList2;
        Node node;
        int n3;
        int n4;
        NodeList nodeList3;
        this.parse((Test)testSuite, element);
        this.elementByTestSuite.put(testSuite, element);
        testSuite.setLocation(XMLUtil.getValue((Element)element, (String)"location"));
        if (testSuite.getTestInvocation() == null && (nodeList3 = XMLUtil.getChildrenByName((Element)element, (String)"referencedTestSuites")) != null) {
            n4 = nodeList3.getLength();
            for (n3 = 0; n3 < n4; ++n3) {
                node = nodeList3.item(n3);
                if (!(node instanceof Element) || (nodeList2 = XMLUtil.getChildrenByName((Element)((Element)node), (String)"testSuite")) == null) continue;
                n2 = nodeList2.getLength();
                for (n = 0; n < n2; ++n) {
                    test = new TestSuite();
                    this.parse((TestSuite)test, (Element)nodeList2.item(n));
                }
            }
        }
        if ((nodeList3 = XMLUtil.getChildrenByName((Element)element, (String)"testCases")) != null) {
            n4 = nodeList3.getLength();
            for (n3 = 0; n3 < n4; ++n3) {
                node = nodeList3.item(n3);
                if (!(node instanceof Element) || (nodeList2 = XMLUtil.getChildrenByName((Element)((Element)node), (String)"testCase")) == null) continue;
                n2 = nodeList2.getLength();
                for (n = 0; n < n2; ++n) {
                    test = new TestCase();
                    ((TestCase)test).setTestSuite(testSuite);
                    this.parse((TestCase)test, (Element)nodeList2.item(n));
                }
            }
        }
        if ((nodeList = XMLUtil.getChildrenByName((Element)element, (String)"behavior")) != null) {
            int n5 = nodeList.getLength();
            for (n4 = 0; n4 < n5; ++n4) {
                nodeList2 = nodeList.item(n4).getChildNodes();
                if (nodeList2 == null) continue;
                this.parse((IActionOwner)testSuite, nodeList2);
            }
        }
    }

    protected void parse(IActionOwner iActionOwner, NodeList nodeList) {
        boolean bl = false;
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Action action;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            String string = element.getTagName();
            if ("testInvocation".equals(string)) {
                action = new TestInvocation();
                action.setOwner(iActionOwner);
                this.parse((TestInvocation)action, element);
                continue;
            }
            if (!"loop".equals(string)) continue;
            action = new Loop();
            action.setOwner(iActionOwner);
            this.parse((Loop)action, element);
            if (((Loop)action).getIterations() <= 1) continue;
            for (int j = 2; j <= ((Loop)action).getIterations(); ++j) {
                action = new Loop();
                action.setOwner(iActionOwner);
                action.setIteration(j);
                this.parse((Loop)action, element);
            }
        }
    }

    protected void parse(TestCase testCase, Element element) {
        this.parse((Test)testCase, element);
    }

    protected void parse(Test test, Element element) {
        this.parse((NamedElement)test, element);
    }

    protected void parse(Loop loop, Element element) {
        this.parse((Action)loop, element);
        loop.setIterations(XMLUtil.getIntValue((Element)element, (String)"iterations"));
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            this.parse((IActionOwner)loop, nodeList);
        }
    }

    protected void parse(TestInvocation testInvocation, Element element) {
        this.parse((Action)testInvocation, element);
        testInvocation.setTestId(XMLUtil.getValue((Element)element, (String)"testId"));
    }

    protected void parse(Action action, Element element) {
        this.parse((NamedElement)action, element);
        action.setSynchronous(Boolean.valueOf(XMLUtil.getValue((Element)element, (String)"synchronous")));
    }

    protected void parse(NamedElement namedElement, Element element) {
        namedElement.setId(XMLUtil.getValue((Element)element, (String)"id"));
        namedElement.setName(XMLUtil.getValue((Element)element, (String)"name"));
        namedElement.setDescription(XMLUtil.getValue((Element)element, (String)"description"));
        this.namedElementById.put(namedElement.getId(), namedElement);
    }
}

