/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.wizard.ReportWizardPage;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.LocationPage;
import org.eclipse.hyades.ui.report.IReportGenerator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class ReportWizard
extends HyadesWizard {
    protected static final String SET_LAST_REPORT = "LAST_REPORT";
    protected static final String SET_LAST_SELECTION = "LAST_FOLDER_SELECTION";
    private ReportWizardPage reportPage;
    private LocationPage locationPage;

    public ReportWizard() {
        this.setWindowTitle(TestUIPlugin.getString("NEW_REPORT_TITLE"));
        IDialogSettings dialogSettings = TestUIPlugin.getInstance().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("ReportWizard");
        if (settings == null) {
            settings = dialogSettings.addNewSection("ReportWizard");
        }
        this.setDialogSettings(settings);
    }

    protected void initPages() {
        this.reportPage = new ReportWizardPage("report", this.getSelection());
        this.reportPage.setTitle(TestUIPlugin.getString("WIZ_TST_REPP_PG_TTL"));
        this.reportPage.setDescription(TestUIPlugin.getString("WIZ_TST_REPP_PG_LOC_DSC"));
        this.locationPage = new LocationPage("location", this.adjustLocation());
        this.locationPage.setTitle(TestUIPlugin.getString("WIZ_TST_REP_PG_TTL"));
        this.locationPage.setDescription(TestUIPlugin.getString("WIZ_TST_REP_PG_LOC_DSC"));
        String fileExtension = this.getFileExtension();
        if (fileExtension != null) {
            this.locationPage.setFileExtension(fileExtension);
            this.locationPage.setFileName("*." + fileExtension);
        }
    }

    protected String getFileExtension() {
        return null;
    }

    protected IStructuredSelection adjustLocation() {
        IResource resource;
        String lastSelection;
        IStructuredSelection structuredSelection = this.getSelection();
        if (this.getDialogSettings() != null && (lastSelection = this.getDialogSettings().get(SET_LAST_SELECTION)) != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(lastSelection)) != null && resource.exists()) {
            structuredSelection = new StructuredSelection((Object)resource);
        }
        return structuredSelection;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.reportPage);
        this.addPage((IWizardPage)this.locationPage);
    }

    public boolean performFinish() {
        IFile file = null;
        IPath path = this.locationPage.getContainerFullPath();
        IContainer res = this.createContainer(path);
        String fileExtension = "report";
        IReportGenerator generator = this.reportPage.getReportGenerator();
        try {
            if (generator != null && generator.getReportFileExtension((ISelection)this.getSelection()) != null) {
                fileExtension = generator.getReportFileExtension((ISelection)this.getSelection());
            }
        }
        catch (Exception e) {
            TestUIPlugin.logError(e);
            String error = e.getLocalizedMessage();
            if (error == null || error.length() == 0) {
                error = e.getMessage();
            }
            if (error == null || error.length() == 0) {
                error = e.getClass().getName();
            }
            MessageDialog.openError((Shell)this.getShell(), (String)TestUIPlugin.getString("W_ERROR"), (String)TestUIPlugin.getString("GENERATE_ERROR_", error));
            return false;
        }
        path = new Path(this.locationPage.getFileName() + "." + fileExtension);
        file = res.getFile(path);
        if (file == null) {
            return false;
        }
        if (file.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)TestUIPlugin.getString("W_QUESTION"), (String)TestUIPlugin.getString("FILE_EXISTS"))) {
            return false;
        }
        InputStream inputStream = null;
        try {
            if (generator != null) {
                inputStream = generator.generate(file, (ISelection)this.getSelection());
            }
        }
        catch (Exception e) {
            TestUIPlugin.logError(e);
            String error = e.getLocalizedMessage();
            if (error == null || error.length() == 0) {
                error = e.getMessage();
            }
            if (error == null || error.length() == 0) {
                error = e.getClass().getName();
            }
            MessageDialog.openError((Shell)this.getShell(), (String)TestUIPlugin.getString("W_ERROR"), (String)TestUIPlugin.getString("GENERATE_ERROR_", error));
            return false;
        }
        if (inputStream == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)TestUIPlugin.getString("W_ERROR"), (String)TestUIPlugin.getString("REOPRT_NO_CONTENT_ERROR_"));
            return false;
        }
        try {
            if (file.exists()) {
                file.delete(true, true, null);
            }
            file.create(inputStream, true, null);
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
            UIUtil.openSaveFileErrorDialog((Shell)this.getShell(), (String)file.getFullPath().toString(), (Throwable)e);
            return false;
        }
        IPreferenceStore store = TestUIPlugin.getInstance().getPreferenceStore();
        store.setValue("OpenReportEditor", this.reportPage.openEditor());
        if (this.reportPage.openEditor()) {
            UIUtil.openEditor((IFile)file, null, (boolean)false);
        }
        this.getDialogSettings().put(SET_LAST_REPORT, this.reportPage.getReportDescription().getName());
        this.getDialogSettings().put(SET_LAST_SELECTION, res.getFullPath().toString());
        return true;
    }

    private IContainer createContainer(IPath path) {
        IFolder container = null;
        IWorkspace workbench = ResourcesPlugin.getWorkspace();
        int segCount = path.segmentCount();
        for (int idx = 0; idx < segCount; ++idx) {
            if (idx == 0) {
                IProject project = workbench.getRoot().getProject(path.uptoSegment(idx + 1).toString());
                if (project == null || !project.exists()) {
                    try {
                        project.create(null);
                    }
                    catch (Exception e) {
                        TestUIPlugin.logError(e);
                        e.printStackTrace();
                    }
                }
                try {
                    project.open(null);
                }
                catch (Exception e) {
                    // empty catch block
                }
                container = project;
                continue;
            }
            IFolder folder = workbench.getRoot().getFolder(path.uptoSegment(idx + 1));
            if (folder == null || !folder.exists()) {
                try {
                    folder.create(false, true, null);
                }
                catch (Exception e) {
                    TestUIPlugin.logError(e);
                    e.printStackTrace();
                }
            }
            container = folder;
        }
        try {
            container.getProject().refreshLocal(2, null);
        }
        catch (CoreException exc) {
            TestUIPlugin.logError(exc);
            exc.printStackTrace();
        }
        return container;
    }
}

