/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.impl.QueryStatement;

public class GetTargetIdStatement
extends QueryStatement {
    protected int sourceId;
    protected int index;
    protected String source;
    protected String target;
    protected String order;
    protected boolean orderFlag;

    public GetTargetIdStatement(DBMap map, DatabaseType dbType, int sourceId, EReference reference, int index) {
        super(dbType, map, (EModelElement)reference);
        this.sourceId = sourceId;
        this.index = index;
        DBMap.ReferenceData data = (DBMap.ReferenceData)this.dbMap.getDBRepresentation((EModelElement)reference);
        this.source = data.getSourceColumn().getName();
        this.target = data.getTargetColumn().getName();
        if (data.getOrderColumn() != null) {
            this.order = data.getOrderColumn().getName();
        }
        this.initial = 0;
    }

    protected void createSelectFrom() {
        this.statement.append("SELECT ");
        this.statement.append(this.addQuotes(this.target));
        this.statement.append(" FROM ");
        this.statement.append(this.addQuotes(this.table.getName()));
    }

    protected void createWhereClause(int begin) {
        this.statement.append(" WHERE ");
        this.statement.append(this.addQuotes(this.source));
        this.statement.append(" = ");
        String id = "" + this.sourceId;
        this.statement.append(id);
        this.statement.append(" AND ");
        this.statement.append(this.addQuotes(this.order));
        this.statement.append(" = ");
        id = "" + this.index;
        this.statement.append(id);
    }
}

