/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.Thd;

public class Monitor
implements Externalizable {
    private static int _curVersion = 1;
    private int _version = -1;
    public String _name = null;
    public int _ID = -1;
    public Thd _owner = null;
    public Vector _waiters = null;
    public int _monitor_type = -1;
    private Properties _props = null;
    public static final int WAIT_MONITOR = 1;
    public static final int SYNC_MONITOR = 2;

    public Monitor(String name, int monitor_type) {
        this._version = _curVersion;
        this._name = name;
        this._monitor_type = monitor_type;
        this._ID = DumpData.getID();
        this._waiters = new Vector();
        this._owner = null;
        this._props = new Properties();
    }

    public String getProperty(String propName) {
        return this._props.getProperty(propName);
    }

    public void setProperty(String propName, String propVal) {
        this._props.setProperty(propName, propVal);
    }

    public void addWaiter(Thd waiter) {
        this._waiters.add(waiter);
        waiter.setWaitMonitor(this);
    }

    public int getId() {
        return this._ID;
    }

    public void setOwner(Thd owner) {
        this._owner = owner;
    }

    public Vector format(int indent, boolean fHtml) {
        int i;
        Vector<String> v = new Vector<String>();
        String sTab = "   ";
        String sIndent = "";
        for (i = 0; i < indent; ++i) {
            sIndent = sIndent + "   ";
        }
        v.add(sIndent + "==" + TAUtils.getNLSValue("ta.format.MonitorDump", "Monitor dump") + "==");
        v.add(sIndent + sTab + this._name);
        v.add(sIndent + sTab + sTab + TAUtils.getNLSValue("ta.format.Waiters", "Waiters") + "....... " + this._waiters.size());
        ++indent;
        for (i = 0; i < this._waiters.size(); ++i) {
            Thd thd = (Thd)this._waiters.elementAt(i);
            v.addAll(thd.format(indent, fHtml));
        }
        return v;
    }

    public void print(int indent, boolean fHtml) {
        Vector v = this.format(indent, fHtml);
        for (int i = 0; i < v.size(); ++i) {
            System.out.println((String)v.elementAt(i));
        }
    }

    public String getName() {
        return this._name;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(_curVersion);
        out.writeObject(this._name);
        out.writeInt(this._ID);
        out.writeObject(this._owner);
        int waiters = this._waiters.size();
        out.writeInt(waiters);
        for (int i = 0; i < waiters; ++i) {
            int waiterId = ((Thd)this._waiters.elementAt(i)).getId();
            out.writeInt(waiterId);
        }
        out.writeInt(this._monitor_type);
        out.writeObject(this._props);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._version = in.readInt();
        this._name = (String)in.readObject();
        this._ID = in.readInt();
        this._owner = (Thd)in.readObject();
        int waiterCount = in.readInt();
        this._waiters = new Vector();
        for (int i = 0; i < waiterCount; ++i) {
            int waiterId = in.readInt();
            this._waiters.add(new Integer(waiterId));
        }
        this._monitor_type = in.readInt();
        this._props = (Properties)in.readObject();
    }

    public void fixupWaiters(DumpData d) {
        Vector tv = this._waiters;
        this._waiters = new Vector();
        int waiters = tv.size();
        if (waiters > 0) {
            for (int i = 0; i < waiters; ++i) {
                int thdID = (Integer)tv.elementAt(i);
                Thd thd = d.getThreadById(thdID);
                this._waiters.add(thd);
            }
        }
    }

    public Monitor() {
    }
}

