/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.outputters;

import java.util.Hashtable;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.impl.Outputter;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.core.LoggingAgent;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CBELogOutputter
extends Outputter
implements IOutputter {
    private LoggingAgent cbelogger = null;
    private static String defaultAgentName = "GenericAdapterCBELogger";
    private String agentName = null;
    private long waitTime = 0L;

    public Object[] processEventItems(Object[] msgs) {
        if (msgs == null) {
            return null;
        }
        return this.processCBEs((CommonBaseEvent[])msgs);
    }

    private CommonBaseEvent[] processCBEs(CommonBaseEvent[] events) {
        if (events.length > 0 && !this.cbelogger.isLogging() && this.getWaitTime() > 0L) {
            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Logging_Agent_Waiting_INFO_");
            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.getAgentName()});
            event.setSeverity((short)10);
            this.log(event);
            while (!this.cbelogger.waitUntilLogging(this.getWaitTime())) {
                event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Logging_Agent_Waiting_INFO_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.getAgentName()});
                event.setSeverity((short)10);
                this.log(event);
            }
        }
        for (int i = 0; i < events.length; ++i) {
            if (events[i] == null) continue;
            try {
                this.cbelogger.write(EventFormatter.toCanonicalXMLString((CommonBaseEvent)events[i], (boolean)false));
                continue;
            }
            catch (Exception ioe) {
                CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Logging_Agent_Write_ERROR_");
                event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.getAgentName()});
                event.setSeverity((short)60);
                this.log(event);
            }
        }
        return events;
    }

    public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig {
        if (!(msgs instanceof CommonBaseEvent[])) {
            throw new AdapterInvalidConfig("This outputter will only accept arrays of CommonBaseEvent");
        }
        return this.testProcessCBEs((CommonBaseEvent[])msgs);
    }

    private CommonBaseEvent[] testProcessCBEs(CommonBaseEvent[] events) {
        return events;
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
        Element element = this.getConfiguration();
        Element outputterTypeInstance = null;
        String waittm = null;
        Object agent = null;
        Hashtable outputterProperties = this.getProperties();
        if (outputterProperties != null && !outputterProperties.isEmpty()) {
            waittm = (String)outputterProperties.get(Messages.getString("HyadesGAwaitTimeAttributeName"));
            if (waittm != null && waittm.length() > 0) {
                this.setWaitTime(Long.valueOf(waittm));
            }
            this.setAgentName((String)outputterProperties.get(Messages.getString("HyadesGAagentNameAttributeName")));
        } else {
            NodeList outputterNodes = element.getChildNodes();
            for (int i = 0; i < outputterNodes.getLength(); ++i) {
                String wtime;
                Element outputterNode;
                if (outputterNodes.item(i).getNodeType() != 1 || !(outputterNode = (Element)outputterNodes.item(i)).getTagName().equals(Messages.getString("HyadesGALogOutputterTypeTagName"))) continue;
                outputterTypeInstance = outputterNode;
                if (outputterTypeInstance.hasAttribute(Messages.getString("HyadesGAwaitTimeAttributeName")) && (wtime = outputterTypeInstance.getAttribute(Messages.getString("HyadesGAwaitTimeAttributeName"))) != null && !wtime.equals("")) {
                    this.setWaitTime(Long.valueOf(wtime));
                }
                if (!outputterTypeInstance.hasAttribute(Messages.getString("HyadesGAagentNameAttributeName"))) continue;
                this.setAgentName(outputterTypeInstance.getAttribute(Messages.getString("HyadesGAagentNameAttributeName")));
            }
        }
        if (this.cbelogger == null) {
            String logAgentName = this.getAgentName() == null ? defaultAgentName : this.getAgentName();
            this.cbelogger = new LoggingAgent(logAgentName);
        }
    }

    public void setAgentName(String aName) {
        this.agentName = aName;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setWaitTime(long wTime) {
        this.waitTime = wTime;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public void stop() {
        this.cbelogger.deregister();
    }
}

