/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.navigator.action;

import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.dialogs.NewWizard;

public class NewObjectAction
extends Action
implements IDisposable {
    private static final int SIZING_WIZARD_WIDTH = 500;
    private static final int SIZING_WIZARD_HEIGHT = 500;
    private IWorkbenchWindow window;
    private IDialogSettings settings;
    private String wizardCategory;
    private String wizardTitle;

    public NewObjectAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        WorkbenchHelp.setHelp((IAction)this, (String)(HyadesUIPlugin.getID() + ".nact0003"));
    }

    public NewObjectAction(IWorkbenchWindow window) {
        this.window = window;
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.setHoverImageDescriptor(images.getImageDescriptor("IMG_TOOL_NEW_WIZARD_HOVER"));
        this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_NEW_WIZARD_DISABLED"));
        this.setToolTipText(this.getText());
        this.setSettings(HyadesUIPlugin.getInstance().getDialogSettings());
        this.wizardTitle = HyadesUIPlugin.getString("W_NEW");
    }

    public void dispose() {
        this.settings = null;
        this.window = null;
    }

    public void setSettings(IDialogSettings settings) {
        this.settings = settings;
    }

    public IDialogSettings getSettings() {
        return this.settings;
    }

    public void setWizardCategory(String wizardCategory) {
        this.wizardCategory = wizardCategory;
    }

    public String getWizardCategory() {
        return this.wizardCategory;
    }

    public void setWizardTitle(String wizardTitle) {
        this.wizardTitle = wizardTitle;
    }

    public String getWizardTitle() {
        return this.wizardTitle;
    }

    public void run() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        NewWizard wizard = new NewWizard();
        String category = this.getWizardCategory();
        if (category != null) {
            wizard.setCategoryId(category);
        }
        ISelection selection = this.window.getSelectionService().getSelection();
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        if (selection instanceof IStructuredSelection) {
            selectionToPass = (IStructuredSelection)selection;
        }
        wizard.init(workbench, (IStructuredSelection)selectionToPass);
        IDialogSettings settings = this.getSettings();
        if (settings != null) {
            wizard.setDialogSettings(settings);
        }
        wizard.setForcePreviousAndNextButtons(true);
        Shell parent = this.window.getShell();
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        dialog.create();
        String title = this.getWizardTitle();
        if (title != null) {
            wizard.setWindowTitle(title);
        }
        dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
        dialog.open();
    }
}

