/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenJavaSource {
    private static final String JAVA_PERSPECTIVE_ID = "org.eclipse.jdt.ui.JavaPerspective";

    public static boolean openSource(String pattern, int javaType, IJavaSearchScope searchScope, boolean switchToJavaPerspective) {
        OpenSourceJavaSearchResultCollector collector = OpenJavaSource.getSearchResults(pattern, javaType, searchScope);
        if (collector != null && collector.getFile() != null) {
            return OpenJavaSource.openWbSource(collector.getFile(), collector.getStart(), collector.getEnd(), switchToJavaPerspective);
        }
        return false;
    }

    public static IFile getSourceFile(String pattern, int javaType, IJavaSearchScope searchScope) {
        OpenSourceJavaSearchResultCollector collector = OpenJavaSource.getSearchResults(pattern, javaType, searchScope);
        if (collector != null) {
            return collector.getFile();
        }
        return null;
    }

    private static OpenSourceJavaSearchResultCollector getSearchResults(String pattern, int javaType, IJavaSearchScope searchScope) {
        if (searchScope == null) {
            searchScope = SearchEngine.createWorkspaceScope();
        }
        if (pattern == null) {
            pattern = "";
        }
        if (pattern != "") {
            SearchEngine searchEngine = new SearchEngine();
            int idx = pattern.indexOf("(");
            idx = idx != -1 ? pattern.substring(0, idx).lastIndexOf("$") : pattern.lastIndexOf("$");
            String className = null;
            if (idx != -1) {
                int idx1;
                if (javaType == 1) {
                    idx1 = pattern.lastIndexOf(".");
                    if (idx1 != -1) {
                        className = pattern.substring(0, idx1);
                    }
                } else if (javaType == 3) {
                    idx1 = pattern.indexOf("(");
                    if (idx1 != -1) {
                        className = pattern.substring(0, idx1);
                    }
                } else {
                    className = pattern;
                }
                pattern = pattern.substring(idx + 1);
            }
            OpenSourceJavaSearchResultCollector collector = new OpenSourceJavaSearchResultCollector(className);
            try {
                searchEngine.search(ResourcesPlugin.getWorkspace(), pattern, javaType, 0, searchScope, (IJavaSearchResultCollector)collector);
            }
            catch (JavaModelException e) {
                // empty catch block
            }
            return collector;
        }
        return null;
    }

    private static boolean openWbSource(IFile res, int start, int end, boolean switchToJavaPerspective) {
        IEditorPart editor = null;
        if (switchToJavaPerspective) {
            IWorkbenchPage javaPage = OpenJavaSource.getJavaActivePage();
            if (javaPage == null) {
                return false;
            }
            try {
                editor = IDE.openEditor((IWorkbenchPage)javaPage, (IFile)res, (boolean)true);
            }
            catch (PartInitException e) {
                HyadesUIPlugin.logError(e);
            }
        } else {
            editor = UIUtil.openEditor(res, null, false);
        }
        try {
            ITextEditor textEditor;
            IDocument document;
            int length;
            if (editor != null && editor instanceof ITextEditor && end - 1 < (length = (document = (textEditor = (ITextEditor)editor).getDocumentProvider().getDocument((Object)editor.getEditorInput())).getLength()) && start < length) {
                textEditor.setHighlightRange(start, end - start, true);
                return true;
            }
        }
        catch (Exception exc) {
            HyadesUIPlugin.logError(exc);
        }
        return false;
    }

    private static IWorkbenchPage getJavaActivePage() {
        IWorkbenchPage page = UIUtil.getActiveWorkbenchPage();
        if (page == null || !page.getPerspective().getId().equals(JAVA_PERSPECTIVE_ID)) {
            IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            page = null;
            try {
                IWorkbenchPage[] persps = dwindow.getPages();
                for (int idx = 0; idx < persps.length; ++idx) {
                    if (!persps[idx].getPerspective().getId().equals(JAVA_PERSPECTIVE_ID)) continue;
                    page = persps[idx];
                    dwindow.setActivePage(page);
                    break;
                }
                if (page == null) {
                    IWorkspaceRoot element = ResourcesPlugin.getWorkspace().getRoot();
                    IWorkbench workBench = dwindow.getWorkbench();
                    if (workBench != null && element != null) {
                        page = workBench.showPerspective(JAVA_PERSPECTIVE_ID, dwindow, (IAdaptable)element);
                    }
                }
            }
            catch (Exception exc) {
                HyadesUIPlugin.logError(exc);
            }
        }
        return page;
    }

    private static class OpenSourceJavaSearchResultCollector
    implements IJavaSearchResultCollector {
        private IResource _resource;
        private int _start;
        private int _end;
        private String _className;

        public OpenSourceJavaSearchResultCollector(String className) {
            this._className = className;
        }

        public void aboutToStart() {
            this._resource = null;
            this._start = -1;
            this._end = -1;
        }

        public void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) {
            boolean found = false;
            if (this._className != null) {
                if (enclosingElement instanceof IType && this._className.compareTo(((IType)enclosingElement).getFullyQualifiedName()) == 0) {
                    found = true;
                } else if (enclosingElement instanceof IMethod && this._className.compareTo(((IMethod)enclosingElement).getDeclaringType().getFullyQualifiedName()) == 0) {
                    found = true;
                }
            } else {
                found = true;
            }
            if (found) {
                this._resource = resource;
                this._start = start;
                this._end = end;
                try {
                    ISourceReference sourceReference;
                    ISourceRange sourceRange;
                    if (enclosingElement != null && enclosingElement instanceof ISourceReference && (sourceRange = (sourceReference = (ISourceReference)enclosingElement).getSourceRange()) != null) {
                        this._start = sourceRange.getOffset();
                        this._end = this._start + sourceRange.getLength();
                    }
                }
                catch (JavaModelException e) {
                    // empty catch block
                }
            }
        }

        public void done() {
        }

        public IProgressMonitor getProgressMonitor() {
            return null;
        }

        public IFile getFile() {
            if (this._resource != null && this._resource.getType() == 1) {
                return (IFile)this._resource;
            }
            return null;
        }

        public int getStart() {
            return this._start;
        }

        public int getEnd() {
            return this._end;
        }
    }
}

