/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ColumnsDialog
extends Dialog
implements SelectionListener {
    private Table _list;
    private Button _moveUp;
    private Button _moveDown;
    private Button _restoreDefaults;
    private ArrayList _data;
    private String _defaultColumnsTemplate;
    private Item _oldSelection;
    private static final int _restoreDefaultsButtonId = 1025;
    private String _title;

    public ColumnsDialog(Shell shell, String windowTitle, Image windowImage, ArrayList data, String defaultColumnsTemplate) {
        super(shell);
        this._title = windowTitle;
        this._defaultColumnsTemplate = defaultColumnsTemplate;
        ColumnsDialog.setDefaultImage((Image)windowImage);
        this._data = new ArrayList(data.size());
        this._data.addAll(data);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 15;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)GridUtil.createFill());
        Label description = new Label(result, 0);
        GridData data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 3;
        description.setLayoutData((Object)data);
        description.setText(TraceUIPlugin.getString("STR_COL_DLG_TEXT"));
        Composite dataComp = new Composite(result, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        dataComp.setLayout((Layout)layout);
        data = GridUtil.createFill();
        data.horizontalSpan = 3;
        dataComp.setLayoutData((Object)data);
        this._list = new Table(dataComp, 2336);
        data = GridUtil.createFill();
        this._list.setLayoutData((Object)data);
        Composite buttonWidget = new Composite(dataComp, 0);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        buttonWidget.setLayoutData((Object)data);
        GridLayout blayout = new GridLayout();
        blayout.numColumns = 1;
        buttonWidget.setLayout((Layout)blayout);
        this._moveUp = new Button(buttonWidget, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._moveUp.setLayoutData((Object)data);
        this._moveUp.setText(TraceUIPlugin.getString("STR_COL_DLG_UP"));
        this._moveDown = new Button(buttonWidget, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._moveDown.setLayoutData((Object)data);
        this._moveDown.setText(TraceUIPlugin.getString("STR_COL_DLG_DOWN"));
        this._list.addSelectionListener((SelectionListener)this);
        this._moveUp.addSelectionListener((SelectionListener)this);
        this._moveDown.addSelectionListener((SelectionListener)this);
        this._moveUp.setEnabled(false);
        this._moveDown.setEnabled(false);
        this.populateList();
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, TraceUIPlugin.getString("STR_COL_DLG_RESTORE_DEFAULTS"), false);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this._data.clear();
            this._data.addAll(ColumnData.createColumnDataFromString(this._defaultColumnsTemplate));
            this.populateList();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public ArrayList getData() {
        return this._data;
    }

    protected void moveDown(int idx) {
        TableItem item = this._list.getItem(idx);
        ColumnData data = (ColumnData)item.getData();
        if (!data.isMovable()) {
            return;
        }
        TableItem newitem = new TableItem(this._list, 32, idx + 2);
        newitem.setChecked(item.getChecked());
        newitem.setText(item.getText());
        newitem.setData((Object)data);
        newitem.setGrayed(item.getGrayed());
        this._list.remove(idx);
        this._list.select(idx + 1);
    }

    protected void moveUp(int idx) {
        TableItem previousItem;
        ColumnData previousItemData;
        TableItem item = this._list.getItem(idx);
        ColumnData data = (ColumnData)item.getData();
        if (!data.isMovable()) {
            return;
        }
        if (idx > 0 && !(previousItemData = (ColumnData)(previousItem = this._list.getItem(idx - 1)).getData()).isMovable()) {
            return;
        }
        TableItem newitem = new TableItem(this._list, 32, idx - 1);
        newitem.setChecked(item.getChecked());
        newitem.setText(item.getText());
        newitem.setData((Object)data);
        newitem.setGrayed(item.getGrayed());
        this._list.remove(idx + 1);
        this._list.select(idx - 1);
    }

    protected void okPressed() {
        if (!this.validate()) {
            String title = TraceUIPlugin.getString("STR_TRACE_MSG");
            String msg = TraceUIPlugin.getString("ERR_SELECT_COLS");
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)msg);
            return;
        }
        this._data.clear();
        for (int idx = 0; idx < this._list.getItemCount(); ++idx) {
            TableItem item = this._list.getItem(idx);
            ColumnData data = (ColumnData)item.getData();
            int style = data.getStyle();
            style = item.getChecked() ? (style |= 1) : (style &= 0xFFFFFFFE);
            this._data.add(new ColumnData(data.name(), data.getInitalPos(), style, data.getAlignment(), data.width()));
        }
        super.okPressed();
    }

    private void populateList() {
        this._list.removeAll();
        for (int idx = 0; idx < this._data.size(); ++idx) {
            ColumnData data = (ColumnData)this._data.get(idx);
            TableItem item = new TableItem(this._list, 0);
            item.setText(data.name());
            item.setChecked(data.visible());
            item.setGrayed(data.isNonDeletable());
            item.setData((Object)data);
        }
    }

    private boolean validate() {
        boolean valid = false;
        for (int idx = 0; idx < this._list.getItemCount(); ++idx) {
            TableItem item = this._list.getItem(idx);
            if (!item.getChecked()) continue;
            return true;
        }
        return valid;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this._moveUp) {
            int idx = this._list.getSelectionIndex();
            if (idx > 0) {
                this.moveUp(idx);
            }
        } else if (e.widget == this._moveDown) {
            int idx = this._list.getSelectionIndex();
            if (idx != -1 && idx < this._list.getItemCount() - 1) {
                this.moveDown(idx);
            }
        } else if (e.widget instanceof Table) {
            TableItem[] items = this._list.getItems();
            for (int x = 0; x < items.length; ++x) {
                boolean checked = items[x].getChecked();
                ColumnData d = (ColumnData)items[x].getData();
                if (checked || !d.isNonDeletable()) continue;
                items[x].setChecked(true);
            }
        }
        int idx = this._list.getSelectionIndex();
        ColumnData data = null;
        ColumnData previousData = null;
        if (idx > 0) {
            previousData = (ColumnData)this._list.getItem(idx - 1).getData();
        }
        if (idx != -1) {
            data = (ColumnData)this._list.getItem(idx).getData();
        }
        this._moveUp.setEnabled(data != null && data.isMovable() && previousData != null && previousData.isMovable());
        this._moveDown.setEnabled(data != null && data.isMovable() && idx < this._list.getItemCount() - 1);
    }
}

