/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.trace.views.util.internal.Coverage;
import org.eclipse.hyades.trace.views.util.internal.CoverageAnalysis;
import org.eclipse.hyades.trace.views.util.internal.CoverageLeaf;
import org.eclipse.hyades.trace.views.util.internal.CoverageUtil;

public class CoverageFolder
extends Coverage {
    private int methods;
    private int methodsHit;
    private ArrayList childs;

    public CoverageFolder(CoverageAnalysis analysis, Coverage parent) {
        super(analysis, parent);
        this.childs = new ArrayList();
    }

    public CoverageFolder(CoverageAnalysis analysis, Coverage parent, CoverageFolder from) {
        super(analysis, parent);
        this.methods = from.getMethods();
        this.methodsHit = from.getMethodsHit();
        this.setCalls(from.getCalls());
        this.childs = null;
    }

    public void parse(EList list) {
        for (int i = 0; i < list.size(); ++i) {
            EObject echild = (EObject)list.get(i);
            if (echild instanceof TRCMethod) {
                CoverageLeaf child = this.analysis.FindCoverageLeaf(this, echild);
                child.parse(echild);
                continue;
            }
            EList subList = null;
            if (echild instanceof TRCClass && !CoverageUtil.isFiltered((TRCClass)echild)) {
                subList = ((TRCClass)echild).getMethods();
            } else if (echild instanceof TRCPackage) {
                subList = ((TRCPackage)echild).getClasses();
            }
            if (subList == null) continue;
            CoverageFolder child = this.analysis.FindCoverageFolder(this, echild);
            child.parse(subList);
        }
    }

    public void compute() {
        this.methods = 0;
        this.methodsHit = 0;
        for (int i = 0; i < this.getChilds().size(); ++i) {
            Coverage child = (Coverage)this.childs.get(i);
            if (child instanceof CoverageFolder) {
                ((CoverageFolder)child).compute();
                this.methods += child.getMethods();
                this.methodsHit += child.getMethodsHit();
                this.setCalls(this.getCalls() + child.getCalls());
                continue;
            }
            ++this.methods;
            if (child.getCalls() <= 0) continue;
            ++this.methodsHit;
            this.setCalls(this.getCalls() + child.getCalls());
        }
    }

    public int getMethods() {
        return this.methods;
    }

    public int getMethodsHit() {
        return this.methodsHit;
    }

    public int getMethodsMissed() {
        return this.methods - this.methodsHit;
    }

    public ArrayList getChilds() {
        return this.childs;
    }

    public void setChilds(ArrayList childs) {
        this.childs = childs;
    }

    public double getPercentage() {
        if (this.getMethods() == 0) {
            return 0.0;
        }
        return (double)this.getMethodsHit() / (double)this.getMethods();
    }
}

