/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;

public class UpdateModel
implements IProfileEventListener {
    private Object selObject;

    public void handleProfileEvent(ProfileEvent event) {
        if (event.getType() == 32 && event.getSource() instanceof EObject) {
            this.selObject = event.getSource();
            if (this.selObject == null) {
                return;
            }
            this.updateDelta();
            this.selObject = null;
        }
    }

    private void updateDelta() {
        if (this.selObject != null) {
            if (this.selObject instanceof TRCAgentProxy) {
                this.updateDelta((TRCAgentProxy)this.selObject);
                return;
            }
            if (this.selObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)this.selObject).getAgentProxies().toArray();
                for (int idx = 0; idx < agents.length; ++idx) {
                    this.updateDelta((TRCAgentProxy)agents[idx]);
                }
                return;
            }
            if (this.selObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)this.selObject).getProcessProxies().toArray();
                for (int idx = 0; idx < processes.length; ++idx) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    for (int i = 0; i < agents.length; ++i) {
                        this.updateDelta((TRCAgentProxy)agents[i]);
                    }
                }
                return;
            }
            if (this.selObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)this.selObject).getNodes().toArray();
                for (int k = 0; k < nodes.length; ++k) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    for (int idx = 0; idx < processes.length; ++idx) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        for (int i = 0; i < agents.length; ++i) {
                            this.updateDelta((TRCAgentProxy)agents[i]);
                        }
                    }
                }
                return;
            }
        }
    }

    private void updateDelta(TRCAgentProxy agent) {
        if (!agent.getType().equals("Profiler") || agent.getAgent() == null || this.getProcess(agent.getAgent()) == null) {
            return;
        }
        TraceUtils.takeSnapshot((TRCProcess)this.getProcess(agent.getAgent()));
    }

    private TRCProcess getProcess(TRCAgent agent) {
        if (agent.getProcess() instanceof TRCProcess) {
            return (TRCProcess)agent.getProcess();
        }
        return null;
    }
}

