/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.core;

import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.core.BasicExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;

public abstract class BaseMessage
extends GraphNode {
    protected Lifeline startLifeline = null;
    protected Lifeline endLifeline = null;
    private String prefId = "PREF_SYNC_MESS";
    protected int eventOccurrence = 0;
    protected boolean visible = true;

    public int getX() {
        return this.getX(false);
    }

    public int getY() {
        if (this.startLifeline != null && this.endLifeline != null) {
            return this.endLifeline.getY() + this.endLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.eventOccurrence;
        }
        if (this.startLifeline != null) {
            return this.startLifeline.getY() + this.startLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.eventOccurrence;
        }
        if (this.endLifeline != null) {
            return this.endLifeline.getY() + this.endLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.eventOccurrence;
        }
        return 0;
    }

    public int getWidth() {
        return this.getWidth(false);
    }

    public int getHeight() {
        return 0;
    }

    protected int getX(boolean quick) {
        int x = 0;
        int activationWidth = 4;
        if (this.startLifeline != null && this.endLifeline != null) {
            x = this.startLifeline.getX() + Metrics.getLifelineWidth() / 2;
        } else {
            if (this.startLifeline != null) {
                x = this.startLifeline.getX() + Metrics.getLifelineWidth() / 2;
            }
            if (this.endLifeline != null) {
                x = this.endLifeline.getX() - 22;
            }
        }
        if (quick) {
            return x;
        }
        if (this.startLifeline != null && this.endLifeline != null && this.startLifeline.getX() > this.endLifeline.getX()) {
            activationWidth = -activationWidth;
        }
        if (this.isMessageStartInActivation(this.eventOccurrence)) {
            x += activationWidth;
        }
        return x;
    }

    protected int getWidth(boolean quick) {
        int width = 0;
        int activationWidth = 4;
        if (this.startLifeline != null && this.endLifeline != null) {
            width = this.endLifeline.getX() + Metrics.getLifelineWidth() / 2 - this.getX(true);
        } else {
            if (this.startLifeline != null) {
                width = Metrics.swimmingLaneWidth() / 2;
            }
            if (this.endLifeline != null) {
                width = Metrics.swimmingLaneWidth() / 2;
            }
        }
        if (quick) {
            return width;
        }
        if (this.startLifeline != null && this.endLifeline != null && this.startLifeline.getX() > this.endLifeline.getX()) {
            activationWidth = -activationWidth;
        }
        if (this.isMessageStartInActivation(this.eventOccurrence)) {
            width -= activationWidth;
        }
        if (this.isMessageEndInActivation(this.eventOccurrence)) {
            width -= activationWidth;
        }
        return width;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setStartLifeline(Lifeline lifeline) {
        this.startLifeline = lifeline;
    }

    public Lifeline getStartLifeline() {
        return this.startLifeline;
    }

    public Lifeline getEndLifeline() {
        return this.endLifeline;
    }

    public void setEndLifeline(Lifeline lifeline) {
        this.endLifeline = lifeline;
    }

    protected void setEventOccurrence(int occurrence) {
        this.eventOccurrence = occurrence;
    }

    public int getEventOccurrence() {
        return this.eventOccurrence;
    }

    protected boolean isMessageStartInActivation(int event) {
        boolean inActivation = false;
        if (this.startLifeline != null) {
            int thisY = this.getY();
            for (int i = 0; i < this.startLifeline.getExecutions().size(); ++i) {
                BasicExecutionOccurrence toDraw = (BasicExecutionOccurrence)this.startLifeline.getExecutions().get(i);
                if (event >= toDraw.startOccurrence && event <= toDraw.endOccurrence) {
                    inActivation = true;
                }
                if (toDraw.getY() > thisY) break;
            }
        }
        return inActivation;
    }

    protected boolean isMessageEndInActivation(int event) {
        boolean inActivation = false;
        if (this.endLifeline != null) {
            int acIndex = this.endLifeline.getExecOccurrenceDrawIndex();
            for (int i = 0; i < this.endLifeline.getExecutions().size(); ++i) {
                BasicExecutionOccurrence toDraw = (BasicExecutionOccurrence)this.endLifeline.getExecutions().get(i);
                if (event >= toDraw.startOccurrence && event <= toDraw.endOccurrence) {
                    inActivation = true;
                }
                if (toDraw.getY() > this.getY()) break;
            }
        }
        return inActivation;
    }

    public boolean contains(int _x, int _y) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        int tempHeight = 10 + Metrics.getMessageFontHeigth();
        if (this.startLifeline == this.endLifeline) {
            if (this.getName().length() * Metrics.getAverageCharWidth() > Metrics.swimmingLaneWidth() - 4 + -20 ? Frame.contains(x + 20 + 10, y, Metrics.swimmingLaneWidth() - 4 + -20, Metrics.getMessageFontHeigth(), _x, _y) : Frame.contains(x + 20 + 10, y, this.getName().length() * Metrics.getAverageCharWidth(), Metrics.getMessageFontHeigth(), _x, _y)) {
                return true;
            }
            if (Frame.contains(x, y - 5, 10, 10, _x, _y)) {
                return true;
            }
            if (Frame.contains(x + 20 - 5, y, 10, height + 10, _x, _y)) {
                return true;
            }
            return Frame.contains(x, y + height - 5 + 10, 10, 10, _x, _y);
        }
        return Frame.contains(x, y - tempHeight, width, tempHeight * 2, _x - tempHeight, _y);
    }

    private void drawMessage(IGC context) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.startLifeline == null && this.endLifeline != null) {
            IColor temp = context.getForeground();
            context.setForeground(Frame.getUserPref().getFontColor(this.prefId));
            context.drawTextTruncatedCentred(this.getName(), x, y - Metrics.getMessageFontHeigth() - 20, width, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            context.setForeground(temp);
            context.drawLine(x, y, x + width, y + height);
            Double xt = new Double(Math.cos(0.75) * 7.0);
            Double yt = new Double(Math.sin(0.75) * 7.0);
            if (context.getLineStyle() == context.getLineSolidStyle()) {
                IColor backcolor = context.getBackground();
                context.setBackground(context.getForeground());
                int[] points = new int[]{x + width, y + height, x + width - xt.intValue(), y + height - yt.intValue(), x + width - xt.intValue(), y + height + yt.intValue(), x + width, y + height};
                context.fillPolygon(points);
                context.drawPolygon(points);
                context.setBackground(backcolor);
            } else {
                int currentStyle = context.getLineStyle();
                int currentWidth = context.getLineWidth();
                context.setLineWidth(currentWidth + 2);
                context.setLineStyle(context.getLineSolidStyle());
                context.drawLine(x + width - xt.intValue(), y + height - yt.intValue(), x + width, y + height);
                context.drawLine(x + width - xt.intValue(), y + height + yt.intValue(), x + width, y + height);
                context.setLineStyle(currentStyle);
                context.setLineWidth(currentWidth);
            }
            IColor storedColor = context.getBackground();
            context.setBackground(context.getForeground());
            int ray = 5;
            if (context.getLineWidth() != 1) {
                ray = ray + 5 - 1;
            }
            context.fillOval(x - ray, y - ray, ray * 2, ray * 2);
            context.setBackground(storedColor);
        } else if (this.endLifeline == null && this.startLifeline != null) {
            IColor temp = context.getForeground();
            context.setForeground(Frame.getUserPref().getFontColor(this.prefId));
            context.drawTextTruncatedCentred(this.getName(), x, y - Metrics.getMessageFontHeigth() - 20, width, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            context.setForeground(temp);
            context.drawLine(x, y, x + width, y + height);
            Double xt = new Double(Math.cos(0.75) * 7.0);
            Double yt = new Double(Math.sin(0.75) * 7.0);
            if (context.getLineStyle() == context.getLineSolidStyle()) {
                IColor backcolor = context.getBackground();
                context.setBackground(context.getForeground());
                int[] points = new int[]{x + width - 5, y + height, x + width - xt.intValue() - 5, y + height - yt.intValue(), x + width - xt.intValue() - 5, y + height + yt.intValue(), x + width - 5, y + height};
                context.fillPolygon(points);
                context.drawPolygon(points);
                context.setBackground(backcolor);
            } else {
                int currentStyle = context.getLineStyle();
                int currentWidth = context.getLineWidth();
                context.setLineWidth(currentWidth + 2);
                context.setLineStyle(context.getLineSolidStyle());
                context.drawLine(x + width - xt.intValue() - 5, y + height - yt.intValue(), x + width - 5, y + height);
                context.drawLine(x + width - xt.intValue() - 5, y + height + yt.intValue(), x + width - 5, y + height);
                context.setLineStyle(currentStyle);
                context.setLineWidth(currentWidth);
            }
            IColor storedColor = context.getBackground();
            context.setBackground(context.getForeground());
            int ray = 5;
            if (context.getLineWidth() != 1) {
                ray = ray + 5 - 1;
            }
            context.fillOval(x + width - ray, y + height - ray, ray * 2, ray * 2);
            context.setBackground(storedColor);
        } else if (this.startLifeline != null && this.endLifeline != null && this.startLifeline == this.endLifeline) {
            int tempy = 10;
            tempy = 5;
            context.drawLine(x, y, x + 10, y);
            context.drawLine(x + 20, y + tempy, x + 20, y + height + 10 - tempy);
            context.drawLine(x, y + height + 10, x + 10, y + height + 10);
            Double xt = new Double(Math.cos(0.75) * 7.0);
            Double yt = new Double(Math.sin(0.75) * 7.0);
            if (context.getLineStyle() == context.getLineSolidStyle()) {
                IColor backcolor = context.getBackground();
                context.setBackground(context.getForeground());
                int[] points = new int[]{x, y + height + 10, x + xt.intValue(), y + height + 10 + yt.intValue(), x + xt.intValue(), y + height + 10 - yt.intValue(), x, y + height + 10};
                context.fillPolygon(points);
                context.drawPolygon(points);
                context.setBackground(backcolor);
            } else {
                int currentStyle = context.getLineStyle();
                int currentWidth = context.getLineWidth();
                context.setLineWidth(currentWidth + 2);
                context.setLineStyle(context.getLineSolidStyle());
                context.drawLine(x + xt.intValue(), y + height + 10 + yt.intValue(), x, y + height + 10);
                context.drawLine(x + xt.intValue(), y + height + 10 - yt.intValue(), x, y + height + 10);
                context.setLineStyle(currentStyle);
                context.setLineWidth(currentWidth);
            }
            context.drawArc(x, y, 20, 2 * tempy, 0, 90);
            context.drawArc(x, y + 10, 20, -2 * tempy, 0, -90);
            context.setForeground(Frame.getUserPref().getFontColor(this.prefId));
            if (this.startLifeline.getIndex() == this.startLifeline.getFrame().getHorizontalIndex()) {
                context.drawTextTruncated(this.getName(), x + width + 20 + 20, y, Metrics.swimmingLaneWidth() / 2 - 8 + -20, 10 - Metrics.getMessageFontHeigth(), !this.isSelected());
            } else {
                context.drawTextTruncated(this.getName(), x + width + 20 + 20, y, Metrics.swimmingLaneWidth() - 8 + -20, 10 - Metrics.getMessageFontHeigth(), !this.isSelected());
            }
        } else if (this.startLifeline != null && this.endLifeline != null) {
            context.drawLine(x, y, x + width, y + height);
            int spaceBTWStartEnd = this.endLifeline.getX() - this.startLifeline.getX();
            double a = height;
            double b = width;
            double angle = Math.atan(a / b);
            Double x1 = new Double(Math.cos(angle - 0.75) * 7.0);
            Double y1 = new Double(Math.sin(angle - 0.75) * 7.0);
            Double x2 = new Double(Math.cos(angle + 0.75) * 7.0);
            Double y2 = new Double(Math.sin(angle + 0.75) * 7.0);
            if (spaceBTWStartEnd > 0) {
                if (context.getLineStyle() == context.getLineSolidStyle()) {
                    IColor backcolor = context.getBackground();
                    context.setBackground(context.getForeground());
                    int[] points = new int[]{x + width - x1.intValue(), y + height - y1.intValue(), x + width, y + height, x + width - x2.intValue(), y + height - y2.intValue(), x + width - x1.intValue(), y + height - y1.intValue()};
                    context.fillPolygon(points);
                    context.drawPolygon(points);
                    context.setBackground(backcolor);
                } else {
                    int currentStyle = context.getLineStyle();
                    int currentWidth = context.getLineWidth();
                    context.setLineWidth(currentWidth + 2);
                    context.setLineStyle(context.getLineSolidStyle());
                    context.drawLine(x + width - x1.intValue(), y + height - y1.intValue(), x + width, y + height);
                    context.drawLine(x + width - x2.intValue(), y + height - y2.intValue(), x + width, y + height);
                    context.setLineStyle(currentStyle);
                    context.setLineWidth(currentWidth);
                }
                context.setForeground(Frame.getUserPref().getFontColor(this.prefId));
                context.drawTextTruncatedCentred(this.getName(), x, y - 20 - Metrics.getMessageFontHeigth(), width, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            } else {
                if (context.getLineStyle() == context.getLineSolidStyle()) {
                    IColor backcolor = context.getBackground();
                    context.setBackground(context.getForeground());
                    int[] points = new int[]{x + width, y + height, x + width + x1.intValue(), y + height + y1.intValue(), x + width + x2.intValue(), y + height + y2.intValue(), x + width, y + height};
                    context.fillPolygon(points);
                    context.drawPolygon(points);
                    context.setBackground(backcolor);
                } else {
                    int currentStyle = context.getLineStyle();
                    int currentWidth = context.getLineWidth();
                    context.setLineWidth(currentWidth + 2);
                    context.setLineStyle(context.getLineSolidStyle());
                    context.drawLine(x + width, y + height, x + width + x1.intValue(), y + height + y1.intValue());
                    context.drawLine(x + width, y + height, x + width + x2.intValue(), y + height + y2.intValue());
                    context.setLineStyle(currentStyle);
                    context.setLineWidth(currentWidth);
                }
                context.setForeground(Frame.getUserPref().getFontColor(this.prefId));
                context.drawTextTruncatedCentred(this.getName(), x + width, y - 20 - Metrics.getMessageFontHeigth(), -width, 20 + Metrics.getMessageFontHeigth(), !this.isSelected());
            }
        }
    }

    public void draw(IGC context) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isSelected()) {
            context.setForeground(Frame.getUserPref().getBackGroundColorSelection());
            context.setLineWidth(5);
            this.drawMessage(context);
            context.setBackground(Frame.getUserPref().getBackGroundColorSelection());
            context.setForeground(Frame.getUserPref().getForeGroundColorSelection());
        } else if (this instanceof SyncMessageReturn) {
            context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_SYNC_MESS_RET"));
            context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_SYNC_MESS_RET"));
            this.prefId = "PREF_SYNC_MESS_RET";
        } else if (this instanceof SyncMessage) {
            context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_SYNC_MESS"));
            context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_SYNC_MESS"));
            this.prefId = "PREF_SYNC_MESS";
        } else if (this instanceof AsyncMessageReturn) {
            context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_ASYNC_MESS_RET"));
            context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_ASYNC_MESS_RET"));
            this.prefId = "PREF_ASYNC_MESS_RET";
        } else if (this instanceof AsyncMessage) {
            context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_ASYNC_MESS"));
            context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_ASYNC_MESS"));
            this.prefId = "PREF_ASYNC_MESS";
        }
        context.setLineWidth(1);
        this.drawMessage(context);
    }
}

