/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.StatisticalModelGraphViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.EditorPart;

public class StatisticalModelEditor
extends EditorPart
implements DisposeListener {
    IEditorSite site;
    IFileEditorInput input;
    IFile file;
    ArrayList sdroots = new ArrayList();
    StatisticalModelGraphViewer agg_editor;
    ArrayList disposables = new ArrayList();

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.site = site;
        this.input = (IFileEditorInput)input;
        EditorPlugin.DBG.info("StatisticalModelEditor: got input");
        this.file = this.input.getFile();
        try {
            EditorPlugin.DBG.info("StatisticalModelEditor: loading file");
            this.load(this.file);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new PartInitException("An error occurred:" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new PartInitException("An I/O error occurred:" + e.getMessage());
        }
        if (this.sdroots.size() == 0) {
            throw new PartInitException("no statistical model found in file");
        }
    }

    public void load(IFile file) throws CoreException, IOException {
        if (file == null) {
            throw new IOException("NULL file!");
        }
        EditorPlugin.DBG.info("StatisticalModelEditor: creating ResourceSetImpl");
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString());
        EditorPlugin.DBG.info("StatisticalModelEditor file URI:" + fileURI);
        if (fileURI == null) {
            throw new IOException("Null fileURI while loading statistical model");
        }
        EditorPlugin.DBG.info("StatisticalModelEditor: getting resource");
        Resource resource = resourceSet.getResource(fileURI, false);
        if (resource == null) {
            EditorPlugin.DBG.info("StatisticalModelEditor: creating resource");
            resource = resourceSet.createResource(fileURI);
        }
        EditorPlugin.DBG.info("StatisticalModelEditor: created resource");
        if (resource == null) {
            throw new IOException("NULL resource!");
        }
        EditorPlugin.DBG.info("StatisticalModelEditor: created resource not NULL");
        resource.load(Collections.EMPTY_MAP);
        EditorPlugin.DBG.info("StatisticalModelEditor: loaded resource");
        EList list = resource.getContents();
        EditorPlugin.DBG.info("StatisticalModelEditor: got contents of resource " + list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            if (o instanceof SDDescriptor) {
                EditorPlugin.DBG.info("StatisticalModelEditor: adding SDDescriptor as root");
                this.sdroots.add(o);
                continue;
            }
            if (!(o instanceof EObject)) continue;
            EObject curr = (EObject)o;
            EList direct_children = curr.eContents();
            for (int k = 0; k < direct_children.size(); ++k) {
                Object co = direct_children.get(k);
                if (!(co instanceof SDDescriptor)) continue;
                EditorPlugin.DBG.info("StatisticalModelEditor: adding depth-1 child SDDescriptor as root");
                this.sdroots.add(co);
            }
        }
    }

    public void createPartControl(Composite parent) {
        System.gc();
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        double d = total - free;
        d /= (double)total;
        System.err.println("MEMORY USED = " + (total - free) / 1024L + "k (" + (d *= 100.0) + "%)");
        parent.addDisposeListener((DisposeListener)this);
        EditorPlugin.DBG.info("CALLING TAB FOLDER CONSTRUCTOR");
        WorkbenchHelp.setHelp((Control)parent, (String)(EditorPlugin.getDefault().getInfopopsId() + ".statcon_anywhere"));
        this.agg_editor = new StatisticalModelGraphViewer(parent, 0, false);
        for (int i = 0; i < this.sdroots.size(); ++i) {
            EditorPlugin.DBG.info("THIS ADD MODEL CALL HAS BEEN REMOVED - THIS CLASS IS OBSOLETE AND SHOULD NOT BE BEING USED");
        }
        this.disposables.add(this.agg_editor);
    }

    public void dispose() {
        super.dispose();
        EditorPlugin.DBG.info(((Object)((Object)this)).getClass() + ":disposed");
        for (int i = 0; i < this.disposables.size(); ++i) {
            try {
                Object o = this.disposables.get(i);
                if (o == null) continue;
                if (o instanceof Widget) {
                    ((Widget)o).dispose();
                    continue;
                }
                if (o instanceof Color) {
                    ((Color)o).dispose();
                    continue;
                }
                if (o instanceof Image) {
                    ((Image)o).dispose();
                    continue;
                }
                try {
                    EditorPlugin.disposeObject(o);
                }
                catch (Throwable e) {
                    EditorPlugin.DBG.info("Class not found when disposing of " + o);
                }
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return false;
    }

    public void setFocus() {
    }
}

