/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal;

import java.util.Vector;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBarEvent;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBarListener;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class ZoomControlBar {
    protected ZoomSlider slider;
    protected double value;
    protected Rectangle area;
    protected Color color;
    protected int size = 11;
    protected boolean enabled = true;
    protected Image image;
    int indent = 3;
    double oldValue;
    Vector listeners = new Vector();
    String tooltip = null;

    public ZoomControlBar(ZoomSlider slider) {
        this.slider = slider;
        this.setColor(slider.getDisplay().getSystemColor(22));
        this.value = slider.getMinVisible();
        slider.addZoomControlBar(this);
    }

    public ZoomControlBar(ZoomSlider slider, double value) {
        this(slider);
        this.setValue(value);
        slider.updateScale();
    }

    public ZoomControlBar(ZoomSlider slider, Color color) {
        this(slider);
        this.setColor(color);
        slider.updateScale();
    }

    public ZoomControlBar(ZoomSlider slider, double value, Color color) {
        this(slider, value);
        this.setColor(color);
        slider.updateScale();
    }

    public ZoomControlBar(ZoomSlider slider, int size) {
        this(slider);
        this.setSize(size);
        slider.updateScale();
    }

    public ZoomControlBar(ZoomSlider slider, double value, int size) {
        this(slider, value);
        this.setSize(size);
        slider.updateScale();
    }

    public ZoomControlBar(ZoomSlider slider, Color color, int size) {
        this(slider, color);
        this.setSize(size);
        slider.updateScale();
    }

    public ZoomControlBar(ZoomSlider slider, double value, Color color, int size) {
        this(slider, value, color);
        this.setSize(size);
        slider.updateScale();
    }

    public void setZoomSlider(ZoomSlider slider) {
        this.slider = slider;
    }

    public ZoomSlider getZoomSlider() {
        return this.slider;
    }

    public void setToolTipText(String text) {
        this.tooltip = text;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public void setValue(double d) {
        this.oldValue = this.value;
        if (d > this.slider.getMaxLimit()) {
            d = this.slider.getMaxLimit();
        }
        if (d < this.slider.getMinLimit()) {
            d = this.slider.getMinLimit();
        }
        this.value = d;
    }

    public double getValue() {
        return this.value;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void hide(Image backBuffer, GC g) {
        g.setClipping(this.getDrawingArea(this.oldValue));
        g.drawImage(backBuffer, 0, 0);
        g.setClipping(0, 0, this.slider.getBounds().width, this.slider.getBounds().height);
    }

    public void paint(GC g) {
        this.area = this.getDrawingArea(this.value);
        if (this.image == null) {
            Image tempImage = new Image((Device)this.slider.getDisplay(), this.area.width, this.area.height);
            this.draw3DBox(new GC((Drawable)tempImage), 0, 0, this.area.width, this.area.height, this.color);
            ImageData imageData = tempImage.getImageData();
            tempImage.dispose();
            for (int i = 0; i < this.area.width; ++i) {
                for (int j = 0; j < this.area.height; ++j) {
                    imageData.setAlpha(i, j, 180);
                }
            }
            this.image = new Image((Device)this.slider.getDisplay(), imageData);
        }
        g.drawImage(this.image, this.area.x, this.area.y);
        g.setForeground(this.slider.getForeground());
        if (this.slider.getOrientation() == 1) {
            g.drawLine(this.area.x + this.area.width / 2, 1, this.area.x + this.area.width / 2, this.indent);
            g.drawLine(this.area.x + this.area.width / 2, this.slider.getBounds().height - this.indent, this.area.x + this.area.width / 2, this.slider.getBounds().height - 1);
        } else {
            g.drawLine(1, this.area.y + this.area.height / 2, this.indent, this.area.y + this.area.height / 2);
            g.drawLine(this.slider.getBounds().width - this.indent, this.area.y + this.area.height / 2, this.slider.getBounds().width - 1, this.area.y + this.area.height / 2);
        }
    }

    protected Rectangle getDrawingArea(double d) {
        if (this.slider.getOrientation() == 0) {
            return new Rectangle(this.indent, (int)this.slider.value2Pixel(d) - this.size / 2, this.slider.getBounds().width - this.indent * 2, this.size);
        }
        return new Rectangle((int)this.slider.value2Pixel(d) - this.size / 2, this.indent, this.size, this.slider.getBounds().height - this.indent * 2);
    }

    public boolean inside(int x, int y) {
        if (this.area == null) {
            return false;
        }
        return this.area.contains(x, y) && this.enabled;
    }

    public void sprayZoomControlBarEvent(boolean finished) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ZoomControlBarListener)this.listeners.elementAt(i)).zoomControlBarChanged(new ZoomControlBarEvent(this, this.value, finished));
        }
    }

    public void addZoomControlBarListener(ZoomControlBarListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeZoomControlBarListener(ZoomControlBarListener listener) {
        this.listeners.removeElement(listener);
    }

    protected void draw3DBox(GC g, int x, int y, int w, int h, Color boxcolor) {
        Color darkColor = null;
        Color darkerColor = null;
        Color lightColor = null;
        double dark = 0.5;
        double darker = 0.1;
        double light = 3.0;
        if (boxcolor == null) {
            EditorPlugin.DBG.warning("3d box colour is null!");
        }
        RGB rgb = boxcolor.getRGB();
        rgb.red = (int)((double)rgb.red * dark);
        rgb.blue = (int)((double)rgb.blue * dark);
        rgb.green = (int)((double)rgb.green * dark);
        darkColor = new Color((Device)this.slider.getDisplay(), rgb);
        rgb = boxcolor.getRGB();
        rgb.red = (int)((double)rgb.red * darker);
        rgb.blue = (int)((double)rgb.blue * darker);
        rgb.green = (int)((double)rgb.green * darker);
        darkerColor = new Color((Device)this.slider.getDisplay(), rgb);
        rgb = boxcolor.getRGB();
        rgb.red = (int)((double)rgb.red * light);
        rgb.blue = (int)((double)rgb.blue * light);
        rgb.green = (int)((double)rgb.green * light);
        if (rgb.red > 255) {
            rgb.red = 255;
        }
        if (rgb.blue > 255) {
            rgb.blue = 255;
        }
        if (rgb.green > 255) {
            rgb.green = 255;
        }
        lightColor = new Color((Device)this.slider.getDisplay(), rgb);
        g.setBackground(darkerColor);
        g.fillRectangle(x, y, w, h);
        g.setBackground(boxcolor);
        g.fillRectangle(x, y, w - 1, h - 1);
        g.setBackground(darkColor);
        g.fillRectangle(x + 1, y + 1, w - 2, h - 2);
        g.setBackground(lightColor);
        g.fillRectangle(x + 1, y + 1, w - 3, h - 3);
        g.setBackground(boxcolor);
        g.fillRectangle(x + 2, y + 2, w - 4, h - 4);
        darkColor.dispose();
        darkerColor.dispose();
        lightColor.dispose();
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        if (this.color != null) {
            this.color.dispose();
        }
    }
}

