/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.dbmodel;

import org.eclipse.emf.ecore.EFactory;
/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage
 * @generated
 */
public interface DbmodelFactory extends EFactory {
	/**

	 * The singleton instance of the factory.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	DbmodelFactory eINSTANCE = new org.eclipse.hyades.resources.database.internal.dbmodel.impl.DbmodelFactoryImpl();

	/**

	 * Returns a new object of class '<em>DB Element</em>'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return a new object of class '<em>DB Element</em>'.

	 * @generated

	 */

	DBElement createDBElement();

	/**

	 * Returns a new object of class '<em>Database</em>'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return a new object of class '<em>Database</em>'.

	 * @generated

	 */

	Database createDatabase();

	/**

	 * Returns a new object of class '<em>Table</em>'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return a new object of class '<em>Table</em>'.

	 * @generated

	 */

	Table createTable();

	/**

	 * Returns a new object of class '<em>Column</em>'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return a new object of class '<em>Column</em>'.

	 * @generated

	 */

	Column createColumn();

	/**

	 * Returns a new object of class '<em>SQL Type</em>'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return a new object of class '<em>SQL Type</em>'.

	 * @generated

	 */

	SQLType createSQLType();

	/**

	 * Returns a new object of class '<em>Constraint</em>'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return a new object of class '<em>Constraint</em>'.

	 * @generated

	 */

	Constraint createConstraint();

	/**

	 * Returns a new object of class '<em>String Type</em>'.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return a new object of class '<em>String Type</em>'.

	 * @generated

	 */

	StringType createStringType();

	/**

	 * Returns the package supported by this factory.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @return the package supported by this factory.

	 * @generated

	 */

	DbmodelPackage getDbmodelPackage();

} //DbmodelFactory

