/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.extensions;
import java.util.List;

import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.DBMapBuilder;
/**
 * This class deletes the resource with the given URI from the resource table,
 * as well as all objects in the resource.
 */
public class DeleteResourceCommand extends DBCommand {
	protected URI uri;
	protected List topLevel;
	protected DatabaseType type;
	/**
	 * Constructor for DB2TableCommand.
	 */
	public DeleteResourceCommand(JDBCHelper helper, DBMap map, DatabaseType type, URI uri) {
		super(helper, map);
		this.type = type;
		this.uri = uri;
	}
	/**
	 * @see org.eclipse.hyades.resources.database.internal.DBCommand#execute()
	 */
	public Object execute() throws Exception {
		try {
			DBCommand getTopLevelObjects = DBCommandFactory.INSTANCE.createGetTopLevelObjects(helper, dbMap, uri);
			topLevel = (List) getTopLevelObjects.execute();
			clearResourceTable();
			deleteObjects();
			helper.commitTransaction();
		} catch (Exception e) {
			helper.rollbackTransaction();
			throw e;
		}
		
		return null;
	}
	protected void clearResourceTable() throws Exception {
		String delete = createStatement();
		helper.executeUpdateStatement(delete);
	}
	protected String createStatement() {
		StringBuffer s = new StringBuffer();
		Table table = dbMap.getResourceTable();
		s.append("DELETE FROM ");
		s.append(addQuotes(table.getName()));
		s.append(" WHERE ");
		s.append(addQuotes(DBMapBuilder.URI_COLUMN_NAME));
		s.append(" = '");
		s.append(uri.toString());
		s.append("'");
		return s.toString();
	}
	protected void deleteObjects() throws Exception {
		DBCommand delete = DBCommandFactory.INSTANCE.createDeleteObjects(helper, dbMap,topLevel);
		delete.execute();
	}
} // DeleteResourceCommand
