/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.recorder.local;

/**
 * Thread which monitors the application being recorded
 * when the application being recorded terminates, this threads shuts down the 
 * recorder in a friendly fashion. 
 * @author Ernest Jessee
 */
public class RecorderStopper extends Thread {
		private Process process;
		private RecorderClient client;
		private boolean bActive;

		public RecorderStopper(Process process, RecorderClient client)
		{			
			setName("Recorder Stopper"); //$NON-NLS-1$
			this.process = process;
			this.client = client;
			String name="Recorder Process Stopper"; //$NON-NLS-1$
			System.err.println("recorder stopper thread started with name: "+name); //$NON-NLS-1$
			setName(name);
		}

		public void run()
		{
			try
			{
				bActive = true;
				System.err.println("about to wait for process"); //$NON-NLS-1$
				process.waitFor();
				bActive = false;
				System.err.println("process terminated"); //$NON-NLS-1$
				client.stopRecording();
			}
			catch (InterruptedException e)
			{
				//this is an expected occurance when the user selects the stop button.
				
			} 
			 			
		}
		
		public boolean isActive()
		{
			return bActive;
		}
}
