/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.http.internal.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.launch.extensions.IRunHandler;

/**
 * @author jnevicos
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class HttpRunHandler implements IRunHandler {
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.launch.extensions.IRunHandler#preRun(org.eclipse.debug.core.ILaunchConfiguration, java.lang.String, org.eclipse.debug.core.ILaunch, org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void preRun(ILaunchConfiguration configuration, String mode,
			ILaunch launch, IProgressMonitor monitor) {
		try {
			TPFTest test = HttpTestLaunchConfigurationFacade.getTest(configuration);
			adjustTestUserCount(test, configuration);
		}
		catch (CoreException e) {}
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.launch.extensions.IRunHandler#postRun(org.eclipse.debug.core.ILaunch)
	 */
	public void postRun(ILaunch launch) {
		// TODO Auto-generated method stub
	}
	
	static void adjustTestUserCount( TPFTest test, ILaunchConfiguration configuration )
	{
		int n = 1;
		try {
			if (test instanceof TPFTestSuite)
			{
				CFGInstance instance = (CFGInstance) ((TPFTestSuite)test).getInstances().get(0);
				n = configuration.getAttribute(HttpTestLaunchConfigurationFacade.PROPERTY_USERS, 1);
				if (n > 0) {
					instance.setMaxCount(n);
					test.eResource().setModified(true);
				}
			}
		}
		catch (CoreException e) {}
	}
}
