/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.http.internal.preferences;

import java.util.Vector;

import org.eclipse.jface.preference.IPreferenceStore;

import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.util.HttpConstants;

public class HttpPreferenceUtil
{
	private static HttpPreferenceUtil instance;

	private static String MAXSAVEDIMPORTINFILEPREF = "MaxSavedImportInfile";
	private static String MAXSAVEDIMPORTTARGETPREF = "MaxSavedImportTarget";
	private static String MAXTHREADSPREF = "MaximumThreadsInGeneratedCode";
	private static String IMPORTASSEPARATEPREF = "ImportAsSeparate";

	private static String SAVEDIMPORTINFILEROOTPREF = "SavedImportInfile";
	private static String SAVEDIMPORTTARGETROOTPREF = "SavedImportTarget";
	private static String SAVEDIMPORTTARGETBASENAME = "SavedImportTCBaseName";

	private static String DEFAULTHOSTNAME = "DefaultHostName";
	private static String DEFAULTHOSTPORT = "DefaultHostPort";
	private static String DEFAULTABSOLUTEPATH = "DefaultAbsolutePath";
	//aberns
	private static String DEFAULTTHINKTIME = "DefaultThinkTime";
	private static String DEFAULTVARIANCE	= "DefaultVariance";
	

	private IPreferenceStore preferenceStore;

	private HttpPreferenceUtil()
	{
		preferenceStore = TestHttpPlugin.getInstance().getPreferenceStore();
		setDefaultValues();
	}
	
	public static HttpPreferenceUtil getInstance()
	{
		if(instance == null)
			instance = new HttpPreferenceUtil();
			
		return instance;
	}
	

	private void setDefaultValues()
	{
		preferenceStore.setDefault(MAXTHREADSPREF, 10);
		preferenceStore.setDefault(MAXSAVEDIMPORTINFILEPREF, 5);
		preferenceStore.setDefault(MAXSAVEDIMPORTTARGETPREF, 5);
		
		preferenceStore.setDefault(DEFAULTHOSTNAME, "");
		preferenceStore.setDefault(DEFAULTHOSTPORT, "80");
		preferenceStore.setDefault(DEFAULTABSOLUTEPATH, "/");
		// aberns		
		preferenceStore.setDefault( DEFAULTTHINKTIME, HttpConstants.DEFAULT_THINK_TIME );
		preferenceStore.setDefault( DEFAULTVARIANCE,  "10" );
		
		preferenceStore.setDefault(IMPORTASSEPARATEPREF, false);
		preferenceStore.setDefault(SAVEDIMPORTTARGETBASENAME, TestHttpPlugin.getString("preference.TestcaseBaseName"));
		
	}

	public int getMaxThreads()
	{
		return getMaxThreads(false);
	}

	public int getMaxThreads(boolean defaultValue)
	{
		if(defaultValue)
			return preferenceStore.getDefaultInt(MAXTHREADSPREF);
			
		return preferenceStore.getInt(MAXTHREADSPREF);
	}
	
	public void setMaxThreads(int newValue)
	{
		preferenceStore.setValue(HttpPreferenceUtil.MAXTHREADSPREF, newValue);
	}

	//

	public String getImportTestcaseBaseName()
	{
		return getImportTestcaseBaseName(false);
	}

	public String getImportTestcaseBaseName(boolean defaultValue)
	{
		if(defaultValue)
			return preferenceStore.getDefaultString(SAVEDIMPORTTARGETBASENAME);
		
		return preferenceStore.getString(SAVEDIMPORTTARGETBASENAME);
	}
	
	public void setImportTestcaseBaseName(String newValue)
	{
		preferenceStore.setValue(HttpPreferenceUtil.SAVEDIMPORTTARGETBASENAME, newValue);
	}

	//

	public boolean getImportAsSeparate()
	{
		return getImportAsSeparate(false);
	}

	public boolean getImportAsSeparate(boolean defaultValue)
	{
		if(defaultValue)
			return preferenceStore.getDefaultBoolean(IMPORTASSEPARATEPREF);
			
		return preferenceStore.getBoolean(IMPORTASSEPARATEPREF);
	}
	
	public void setImportAsSeparate(boolean newValue)
	{
		preferenceStore.setValue(HttpPreferenceUtil.IMPORTASSEPARATEPREF, newValue);
	}
	
	//

	public int getSavedInfileHistorySize()
	{
		return getSavedInfileHistorySize(false);
	}

	public int getSavedInfileHistorySize(boolean defaultValue)
	{
		if(defaultValue)
			return preferenceStore.getDefaultInt(MAXSAVEDIMPORTINFILEPREF);
		
		return preferenceStore.getInt(MAXSAVEDIMPORTINFILEPREF);
	}

	public void setSavedInfileHistorySize(int newValue)
	{
		preferenceStore.setValue(HttpPreferenceUtil.MAXSAVEDIMPORTINFILEPREF, newValue);
	}

	public String[] getInfileHistory()
	{
		int maxEntries;
		int i;
		String tempString;

		maxEntries = getSavedInfileHistorySize();
		Vector V = new Vector();

		for (i = 1; i <= maxEntries; i++)
		{
			tempString = preferenceStore.getString(SAVEDIMPORTINFILEROOTPREF + "." + i);
			if (tempString != null)
				if (!tempString.equals(""))
					V.addElement(tempString);
		}

		String[] res = new String[V.size()];
		for (i = 0; i < res.length; i++)
		{
			res[i] = (String) V.elementAt(i);
		}

		return res;
	}

	public void addToInfileHistory(String fileName)
	{
		int maxEntries;
		int numEntries;

		String[] tempHistory = getInfileHistory();

		for (int y = 0; y < tempHistory.length; y++)
			if (tempHistory[y].equals(fileName))
				return;

		maxEntries = preferenceStore.getInt(MAXSAVEDIMPORTINFILEPREF);
		if (maxEntries < 1)
			maxEntries = getSavedInfileHistorySize(true);

		numEntries = tempHistory.length;

		// always add at end to avoid i/o - let ui go backwards to stack latest on top
		if (numEntries < maxEntries)
		{
			preferenceStore.setValue(SAVEDIMPORTINFILEROOTPREF + "." + (numEntries + 1), fileName);
		}
		else
		{
			int offsetAdjust = numEntries - maxEntries;
			for (int t = 1; t < maxEntries; t++)
			{
				preferenceStore.setValue(SAVEDIMPORTINFILEROOTPREF + "." + t, tempHistory[t + offsetAdjust]);
			}
			preferenceStore.setValue(SAVEDIMPORTINFILEROOTPREF + "." + maxEntries, fileName);
		}
	}

	public int getSavedTargetHistorySize()
	{
		return getSavedTargetHistorySize(false);
	}

	public int getSavedTargetHistorySize(boolean defaultValue)
	{
		if(defaultValue)
			return preferenceStore.getDefaultInt(MAXSAVEDIMPORTTARGETPREF);
		
		return preferenceStore.getInt(MAXSAVEDIMPORTTARGETPREF);
	}

	public void setSavedTargetHistorySize(int newValue)
	{
		preferenceStore.setValue(MAXSAVEDIMPORTTARGETPREF, newValue);
	}

	public String[] getTargetHistory()
	{
		int maxEntries;
		int i;
		String tempString;

		maxEntries = getSavedTargetHistorySize();
		Vector V = new Vector();

		for (i = 1; i <= maxEntries; i++)
		{
			tempString = preferenceStore.getString(SAVEDIMPORTTARGETROOTPREF + "." + i);
			if (tempString != null)
				if (!tempString.equals(""))
					V.addElement(tempString);
		}

		String[] res = new String[V.size()];
		for (i = 0; i < res.length; i++)
		{
			res[i] = (String) V.elementAt(i);
		}

		return res;
	}

	public void addToTargetHistory(String fileName)
	{
		int maxEntries;
		int numEntries;

		String[] tempHistory = getTargetHistory();

		for (int y = 0; y < tempHistory.length; y++)
			if (tempHistory[y].equals(fileName))
				return;

		maxEntries = preferenceStore.getInt(MAXSAVEDIMPORTTARGETPREF);
		if (maxEntries < 1)
			maxEntries = getSavedTargetHistorySize(true);

		numEntries = tempHistory.length;

		// always add at end to avoid i/o - let ui go backwards to stack latest on top
		if (numEntries < maxEntries)
		{
			preferenceStore.setValue(SAVEDIMPORTTARGETROOTPREF + "." + (numEntries + 1), fileName);
		}
		else
		{
			int offsetAdjust = numEntries - maxEntries;
			for (int t = 1; t < maxEntries; t++)
			{
				preferenceStore.setValue(SAVEDIMPORTTARGETROOTPREF + "." + t, tempHistory[t + offsetAdjust]);
			}
			preferenceStore.setValue(SAVEDIMPORTTARGETROOTPREF + "." + maxEntries, fileName);
		}
	}

	//

	public String getDefaultHostName()
	{
		return getDefaultHostName(false);
	}

	public String getDefaultHostName(boolean defaultValue)
	{
		if(defaultValue)
			return preferenceStore.getDefaultString(DEFAULTHOSTNAME);
			
		return preferenceStore.getString(DEFAULTHOSTNAME);
	}

	public void setDefaultHostName(String value)
	{
		preferenceStore.setValue(DEFAULTHOSTNAME, value);
	}

	//

	public String getDefaultHostPort()
	{
		return getDefaultHostPort(false);
	}

	public String getDefaultHostPort(boolean defaultValue)
	{
		if(defaultValue)
			return preferenceStore.getDefaultString(DEFAULTHOSTPORT);
			
		return preferenceStore.getString(DEFAULTHOSTPORT);
	}

	public void setDefaultHostPort(String value)
	{
		preferenceStore.setValue(DEFAULTHOSTPORT, value);
	}

	//
	public String getDefaultThinkTime()
	{
		return getDefaultThinkTime(false);
	}

	public String getDefaultThinkTime(boolean defaultValue)
	{
		if(defaultValue)
			return preferenceStore.getDefaultString(DEFAULTTHINKTIME);
			
		return preferenceStore.getString(DEFAULTTHINKTIME);
	}

	public void setDefaultThinkTime(String value)
	{
		preferenceStore.setValue(DEFAULTTHINKTIME, value);
	}


	// aberns
	public String getDefaultVariance()
	{
		return getDefaultVariance(false);
	}

	public String getDefaultVariance(boolean defaultValue)
	{
		if(defaultValue)
			return preferenceStore.getDefaultString(DEFAULTVARIANCE);
			
		return preferenceStore.getString(DEFAULTVARIANCE);
	}

	public void setDefaultVariance(String value)
	{
		preferenceStore.setValue(DEFAULTVARIANCE, value);
	}
	
	public String getDefaultAbsolutePath()
	{
		return getDefaultAbsolutePath(false);
	}

	public String getDefaultAbsolutePath(boolean defaultValue)
	{
		if(defaultValue)
			return preferenceStore.getDefaultString(DEFAULTABSOLUTEPATH);
			
		return preferenceStore.getString(DEFAULTABSOLUTEPATH);
	}

	public void setDefaultAbsolutePath(String value)
	{
		preferenceStore.setValue(DEFAULTABSOLUTEPATH, value);
	}
}