/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions.widgets;


/**
 * A filter criteria is a criteria than can be activated or not.
 */
public class FilterCriteria {

	private Criteria criteria;
	private boolean active;
	
	/**
	 * @param criteria_
	 * @param active_
	 */
	public FilterCriteria(Criteria criteria_, boolean active_) {
		setCriteria(criteria_);
		setActive(active_);
	}
	
	/**
	 * @param criteria_
	 */
	public void setCriteria(Criteria criteria_) {
		criteria = criteria_;
	}
	
	public Criteria getCriteria() {
		return criteria;
	}
	
	/**
	 * @param active_
	 */
	public void setActive(boolean active_) {
		active = active_;
	}
	
	
	public boolean isActive() {
		return active;
	}
}