/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions.widgets;

import java.text.MessageFormat;

import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider;
import org.eclipse.hyades.uml2sd.util.ContextIDs;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * This is the filters list dialog.<br>
 * It is associated to an SDView and to a ISDFilterProvider.<br> 
 */
public class PagesDialog extends Dialog {
	
	/**
	 * viewer and provided are kept here as attributes
	 */
	private IViewPart viewer = null;	
	private ISDAdvancedPagingProvider provider = null;
	private TextArea currentPage/*, maxItemByPage*/;
	private Label totalPageComment/*, totalItemComment*/;
	
	/**
	 * This is a Text Control that accepts only digits and ensures that bounds are respected
	 */
	private class TextArea {
		
		private Text text;
		int min, max;
		
		public TextArea(Composite parent) {
			text = new Text(parent, SWT.SINGLE | SWT.BORDER | SWT.RIGHT);
//			text.addVerifyListener(new VerifyListener() {
//				public void verifyText(VerifyEvent e) {
//					if (e.character == '\0' ||
//						Character.isDigit(e.character)) {
//						e.doit = true;
//					} else {
//						e.doit = false;
//					}
//				}});
			text.setTextLimit(10);
			GridData data = new GridData();
			data.widthHint = convertWidthInCharsToPixels(10);
			text.setLayoutData(data);
		}
		
		public void setValue(int v) {
			int value = Math.max(min, Math.min(max, v));
			text.setText(Integer.toString(value));
		}
		
		public int getValue() {
			int res;
			try {
				res = Integer.parseInt(text.getText());
			} catch (Exception e) {
				// ignored
				res = 0;
			}
			return Math.max(min, Math.min(max, res));
		}
		
		public void setBounds(int min_, int max_) {
			min = Math.max(0, min_);
			max = Math.max(min, max_);
			Integer tab[] = new Integer[2];
			tab[0] = new Integer(min);
			tab[1] = new Integer(max);
			text.setToolTipText(MessageFormat.format(SDViewerPlugin.getResourceString("PAGES_BOUNDS"), tab)); //$NON-NLS-1$
		}
	}
	
	/**
	 * 
	 */
	private void updateComments() {
		int pages = Math.max(0, provider.pagesCount());
		String totalPageCommentText = SDViewerPlugin.getResourceString("PAGES_TOTAL") + pages + " "; //$NON-NLS-1$ //$NON-NLS-2$
		if (pages == 0) {
			totalPageCommentText += SDViewerPlugin.getResourceString("PAGES_NO_PAGES"); //$NON-NLS-1$
		} else if (pages == 1) {
			totalPageCommentText += SDViewerPlugin.getResourceString("PAGES_ONE_PAGE"); //$NON-NLS-1$
		} else {
			totalPageCommentText += SDViewerPlugin.getResourceString("PAGES_SEVERAL_PAGES"); //$NON-NLS-1$
		}
		totalPageComment.setText(totalPageCommentText);

//		int items = Math.max(0, provider.itemsTotalCount());
//		String currentItemsCommentText = SDViewerPlugin.getResourceString("PAGES_TOTAL_ITEMS") + items + " "; //$NON-NLS-1$ //$NON-NLS-2$
//		if (items == 0) {
//			currentItemsCommentText += provider.noItemsText();
//		} else if (items == 1) {
//			currentItemsCommentText += provider.oneItemText();
//		} else {
//			currentItemsCommentText += provider.itemsText();
//		}
//		totalItemComment.setText(currentItemsCommentText);
	}
	
	/**
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	public Control createDialogArea(Composite parent) {
		
		Group ret = new Group(parent, SWT.NONE);
		WorkbenchHelp.setHelp(ret,SDViewerPlugin.getId()+ContextIDs.UML2SDPAGE);
		GridData data = new GridData();
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		ret.setLayoutData(data);
		ret.setText(SDViewerPlugin.getResourceString("PAGES_GROUP_TITLE")); //$NON-NLS-1$

		FillLayout fillLayout = new FillLayout(SWT.VERTICAL); 
		ret.setLayout(fillLayout);
		
		Label label = new Label(ret, SWT.NONE);
		label.setText(SDViewerPlugin.getResourceString("PAGES_CURRENT_PAGE")); //$NON-NLS-1$
		
		currentPage = new TextArea(ret);
		currentPage.setBounds(1, provider.pagesCount());
		currentPage.setValue(provider.currentPage()+1);

		totalPageComment = new Label(ret, SWT.NONE);
		totalPageComment.setAlignment(SWT.RIGHT);

//		totalItemComment = new Label(ret, SWT.NONE);
//
//		Label label2 = new Label(ret, SWT.NONE);
//		String tab[] = new String[1];
//		tab[0] = provider.itemsText();
//		label2.setText(MessageFormat.format(SDViewerPlugin.getResourceString("PAGES_MAX_ITEMS_BY_PAGE"), tab)); //$NON-NLS-1$
//
//		maxItemByPage = new TextArea(ret);
//		maxItemByPage.setBounds(100, 10*1000*1000);
//		maxItemByPage.setValue(provider.maxItemsByPageCount());

		updateComments();

		getShell().setText(SDViewerPlugin.getResourceString("PAGES_TITLE")); //$NON-NLS-1$
		return ret;
	}
	
	/**
	 * @param view_
	 * @param loader_
	 */
	public PagesDialog(IViewPart view_, ISDAdvancedPagingProvider loader_) {
		super (view_.getSite().getShell());
		viewer = view_;
		provider = loader_;
		setShellStyle(SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
	}
	
	/**
	 * Opens the dialog box
	 */
	public int open() {
		create();
		getShell().pack();
		getShell().setLocation(getShell().getDisplay().getCursorLocation());
		return super.open();
	}
	
	/**
	 * Called when the dialog box ok button is pressed
	 */
	public void okPressed()	{
		//int maxItemByPageValue = maxItemByPage.getValue();
		int currentPageValue = currentPage.getValue()-1;
		super.close();
		//provider.pageSettingsChanged(maxItemByPageValue, currentPageValue);
		provider.pageNumberChanged(currentPageValue);
	}
	
}

