package org.eclipse.hyades.logging.core;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * A typed exception for all serialization APIs in
 * <code>org.eclipse.hyades.logging.core.XmlUtility</code> that serialize a
 * Document Object Model (DOM) to an XML document.
 * </p>
 * 
 * @author Paul E. Slauenwhite
 * @version June 2, 2004
 * @since June 2, 2004
 * @see java.lang.Exception
 * @see org.eclipse.hyades.logging.core.XmlUtility
 */
public class SerializationException extends Exception {

    /**
     * @see java.lang.Exception#Exception()
     */
    public SerializationException() {
        super();
    }

    /**
     * @see java.lang.Exception#Exception(java.lang.String)
     */
    public SerializationException(String message) {
        super(message);
    }
}