/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.loaders.trace.TraceUtils.InvocationInfo;
import org.eclipse.hyades.loaders.util.AgentsContext;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;
import org.eclipse.hyades.models.hierarchy.impl.UnresolvedCorrelationImpl;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCFullMethodInvocationImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadImpl;
/**
 * @author slavescu
 *  
 */
public class XMLmethodEntryLoader extends TraceMethodBaseLoader {
	//~ Static fields/initializers
	// -----------------------------------------------------------------
	//    private static final String THREAD_ID_REF = "threadIdRef";
	protected static final String INVOCATION_CONTEXT = "InvocationContext";
	protected static final String AGENT_ID_REF = "agentIdRef";
	protected static final String PROCESS_ID_REF = "processIdRef";
	protected static final String NODE_ID_REF = "nodeIdRef";
	protected static final String SEQUENCE_COUNTER = "sequenceCounter";
	//	protected static final String TICKET = "ticket";
	//	protected static final String STACK_DEPTH = "stackDepth";
	private static final Object REMOTE_INVOCATION_RESOLUTION_LOCK = new Object();
	//~ Instance fields
	// ----------------------------------------------------------------------------
	private InvocationContext invocationContext = new InvocationContext();
	private boolean activeInvocationContext;
	private long sequenceCounter;
	//~ Methods
	// ------------------------------------------------------------------------------------
	public void addAttribute(String name, String value) {
		if (!loadToModel) {
			return;
		}
		switch (LoadersUtils.getHashCode(name)) {
			case TraceConstants.STACK_DEPTH_int :
				stackDepth = Short.parseShort(value);
				break;
			case TraceConstants.TICKET_int :
				if (!activeInvocationContext) {
					ticket = Long.parseLong(value);
				} else {
					invocationContext.setInvocationTicket(Long.parseLong(value));
				}
				break;
			case TraceConstants.SEQUENCE_COUNTER_int :
				if (!activeInvocationContext) {
					sequenceCounter = Long.parseLong(value);
				} else {
					invocationContext.setInvocationSequenceCounter(Long.parseLong(value));
				}
				break;
			case TraceConstants.NODE_ID_REF_int :
				if (activeInvocationContext) {
					invocationContext.setInvocationNodeIdRef(value);
				}
				break;
			case TraceConstants.PROCESS_ID_REF_int :
				if (activeInvocationContext) {
					invocationContext.setInvocationProcessIdRef(value);
				}
				break;
			case TraceConstants.AGENT_ID_REF_int :
				if (activeInvocationContext) {
					invocationContext.setInvocationAgentIdRef(value);
				}
				break;
			case TraceConstants.THREAD_ID_REF_int :
				if (activeInvocationContext) {
					invocationContext.setInvocationThreadIdRef(Integer.parseInt(value));
				} else {
					threadIdRef = Integer.parseInt(value);
				}
				break;
			case TraceConstants.VALUE_int :
				if (objectValue!=null) {
					objectValue.setStringValue(value);
				}
				break;
			default :
				super.addAttribute(name, value);
				break;
		}
	}
	public void addYourselfInContext() {
		if (!loadToModel) {
			return;
		}
		theProcess = getProcess();
		theThread = getThreadByIdRef(theProcess);
		Object csKey = LoadersUtils.getLookUpKey(threadIdRef);
		cs = (CallStackPerThread) LookupServiceExtensions.getInstance().locate(context, CallStackPerThread.class, csKey);
		if (cs == null) {
			cs = new CallStackPerThread();
			LoadersUtils.registerGenericLookUpEntry(context, csKey, cs);
		}
		invocationPool = cs.invocationPool;
		dispatchProcessMode(ProcessSteps.ALL);
		setMaxStackDepth(theThread);
	}
	public void cleanUp(HierarchyContext context) {
		LookupServiceExtensions.getInstance().deregister(context, CallStackPerThread.class);
		super.cleanUp();
	}
	public void endChild(String name) {
	}
	public void initialize(HierarchyContext context, String name) {
		loadToModel = context.isLoadToModel();
		if (!loadToModel) {
			return;
		}
		super.initialize(context, name);
		activeInvocationContext = false;
		stackDepth = 0;
		ticket = 0;
		fullInvoker = null;
		sequenceCounter = 0;
		inputValues.clear();
		outputValues.clear();
		objectValue=null;
	}
	public void startChild(String name) {
		if (!loadToModel) {
			return;
		}
		if (name.equals(INVOCATION_CONTEXT)) {
			activeInvocationContext = true;
			invocationContext.setInvocationAgentIdRef(null);
			invocationContext.setInvocationNodeIdRef(null);
			invocationContext.setInvocationProcessIdRef(null);
			invocationContext.setInvocationSequenceCounter(0);
			invocationContext.setInvocationThreadIdRef(0);
			invocationContext.setInvocationTicket(0);
		} else
			super.startChild(name);
	}
	//    private void addForwardInvocation() {
	//        Object key =
	// LoadersUtils.getLookUpKey(TraceUtils.getForwardInvocationsId(invocationContext));
	//        ForwardInvocations forwardInvocations = (ForwardInvocations)
	// LookupServiceExtensions.getInstance().locate(null,
	// ForwardInvocations.class, key);
	//
	//        if (forwardInvocations == null) {
	//            forwardInvocations = new ForwardInvocations();
	//            LoadersUtils.registerGenericLookUpEntry(null, key, forwardInvocations);
	//        }
	//
	//        InvocationContext target = new InvocationContext();
	//
	//        target.setInvocationAgentIdRef(context.getAgent().getRuntimeId());
	//        target.setInvocationNodeIdRef(context.getNode().getRuntimeId());
	//        target.setInvocationProcessIdRef(context.getProcessProxy().getRuntimeId());
	//        target.setInvocationSequenceCounter(sequenceCounter);
	//        target.setInvocationThreadIdRef(threadIdRef);
	//        target.setInvocationTicket(ticket);
	//
	//        forwardInvocations.getInvokes(TraceUtils.getMethodInvocationId(invocationContext),
	// true).add(target);
	//    }
	protected void addForwardInvocation(TRCMethodInvocation invocation) {
		String contextId = invocationContext.getInvocationAgentIdRef() + "/" + invocationContext.getInvocationThreadIdRef() + "/" + invocationContext.getInvocationTicket() + "/" + invocationContext.getInvocationSequenceCounter();
		UnresolvedCorrelation unresolvedCorrelation = HierarchyFactory.eINSTANCE.createUnresolvedCorrelation();
		unresolvedCorrelation.setContextId(contextId);
		CorrelationSourceInfo correlationSourceInfo = HierarchyFactory.eINSTANCE.createCorrelationSourceInfo();
		correlationSourceInfo.setOwner(invocation);
		correlationSourceInfo.setReference(TracePackage.eINSTANCE.getTRCMethodInvocation_InvokedBy());
		unresolvedCorrelation.getSourceInfos().add(correlationSourceInfo);
		unresolvedCorrelation.setAgent(context.getAgent());
	}
	/**
	 *  
	 */
	protected void processEF(int step) {
		super.processEF(step);
		theClass = getClassByIdRef(theThread, TRCFullTraceObjectImpl.class, 0);
		theMethod = getMethodByIdRef(theClass);
		if (objIdRef > 0) {
			theObject = getObjectByIdRef(objIdRef, TRCFullTraceObjectImpl.class);
		} else {
			theObject = getClassObject(theMethod.getDefiningClass(), TRCFullTraceObjectImpl.class);
		}
		if (theObject == null) {
			theObject = TraceFactory.eINSTANCE.createTRCFullTraceObject();
		}
		/* Create the method invocation element */
		fullInvocation = TraceFactory.eINSTANCE.createTRCFullMethodInvocation();
		fullInvocation.setStackDepth(stackDepth);
		fullInvocation.setEntryTime(createDeltaTime());
		fullInvocation.setTicket(ticket);
		fullInvocation.setMethod(theMethod);
		fullInvocation.setThread(theThread);
		fullInvocation.setProcess(theProcess);
		fullInvocation.setOwningObject((TRCFullTraceObject) theObject);
        
		addInputOutputValues();
        
		synchronized (REMOTE_INVOCATION_RESOLUTION_LOCK) {
			setInvokerMethod(theThread, fullInvocation);
			updateForwardInvokes(fullInvocation);
		}
		if (cs.isEmpty()) {
			theThread.getInitialInvocations().add(fullInvocation);
		}
		updateStatisticalInfo(theThread, fullInvoker, fullInvocation, theMethod, (TRCFullTraceObject) theObject, theClass);
		cs.push(invocationPool.allocInvocation(fullInvocation, cs));
		//        LookupServiceExtensions.getInstance().register(context,
		// fullInvocation);
	}
	/**
	 *  
	 */
	protected void processES(int step) {
		super.processES(step);
		theClass = getClassByIdRef(theThread, TRCFullTraceObjectImpl.class, 0);
		theMethod = getMethodByIdRef(theClass);
		if (objIdRef > 0) {
			virtualObject = (VirtualObjectInfo) LookupServiceExtensions.getInstance().locate(context, VirtualObjectInfo.class, LoadersUtils.getLookUpKey(objIdRef));
			if (virtualObject != null) {
				theObject = getClassObject(virtualObject.myClass, TRCFullTraceObjectImpl.class);
			} else {
				return;
			}
		} else {
			theObject = getClassObject(theClass, TRCFullTraceObjectImpl.class);
		}
		updateStatisticalInfoOnly(theMethod, (TRCFullTraceObject) theObject, theClass, theThread, createDeltaTime());
	}
	/**
	 * @return The invoker's TRCMethodInvocation.
	 */
	private TRCMethodInvocation setInvokerMethod(TRCThread thread, TRCMethodInvocation invocation) {
		/*
		 * If there is no invocation context then we were invoked on the current
		 * thread and we just need to look at the top of the stack to find our
		 * parent. Otherwise, we need to to look for our invoker based upon the
		 * context information we have. If we cannot find our invoker we can add
		 * this to the bottom of the stack initially and then update it later
		 * when our invoker is loaded.
		 */
		if (activeInvocationContext) {
			fullInvoker = resolveInvocation(invocationContext);
			if (fullInvoker == null) {
				/*
				 * If we get this far we have arrived before our invokers method
				 * entry, so add us to the callee of the remote method
				 */
				addForwardInvocation(invocation);
			} else {
				//System.out.println("Remote Invocation -- In order");
				invocation.setInvokedBy(fullInvoker);
			}
		} else {
			/* Local invocation or we could not find our invoker */
			if ((cs != null) && !cs.isEmpty()) {
				fullInvoker = ((InvocationInfo) cs.peek()).getMethodInvocation();
			}
			if (fullInvoker != null) {
				invocation.setInvokedBy(fullInvoker);
			}
		}
		return fullInvoker;
	}
	private boolean checkTicket(TRCThread theThread, EList list, long ticket) {
		boolean inOrder = false;
		for (Iterator iter = list.iterator(); iter.hasNext();) {
			fullInvoker = (TRCFullMethodInvocation) iter.next();
			if (fullInvoker.getClass() != TRCFullMethodInvocationImpl.class) {
				continue;
			}
			if ((fullInvoker.getThread() == theThread) && (((TRCFullMethodInvocationImpl) fullInvoker).getTicket() == ticket)) {
				inOrder = true;
				break;
			}
			if (checkTicket(theThread, fullInvoker.getInvokes(), ticket)) {
				inOrder = true;
				break;
			}
		}
		return inOrder;
	}
	private TRCFullMethodInvocation resolveInvocation(InvocationContext invContext) {
		TRCFullMethodInvocation targetInvocation = null;
		try {
			TRCAgent targetAgent = null;
			HierarchyContext invokerContext;
			AgentsContext agentsContext = (AgentsContext) LookupServiceExtensions.getInstance().locate(null, AgentsContext.class, LoadersUtils.getLookUpKey(invContext.getInvocationAgentIdRef()));
			if (agentsContext != null) {
				targetAgent = agentsContext.getActiveAgent(context.getAgent());
			}
			if (targetAgent != null) {
				HierarchyContext targetContext = LoadersUtils.locateHierarchyContext(targetAgent);
				if (targetContext != null) {
					targetInvocation = (TRCFullMethodInvocation) LookupServiceExtensions.getInstance().locate(targetContext, TRCFullMethodInvocation.class, LoadersUtils.getLookUpKey(TraceUtils.getMethodInvocationId(invContext)));
					if (targetInvocation == null) {
						boolean inOrder = false;
						TRCThread targetThread = (TRCThread) LookupServiceExtensions.getInstance().locate(targetContext, TRCThreadImpl.class, LoadersUtils.getLookUpKey(invContext.getInvocationThreadIdRef()));
						if (targetThread != null) {
							Iterator invocationIterator = targetThread.getInitialInvocations().iterator();
							while (invocationIterator.hasNext()) {
								fullInvoker = (TRCFullMethodInvocation) invocationIterator.next();
								if (fullInvoker.getClass() != TRCFullMethodInvocationImpl.class) {
									continue;
								}
								if ((fullInvoker.getThread() == targetThread) && (((TRCFullMethodInvocationImpl) fullInvoker).getTicket() == invContext.getInvocationTicket())) {
									inOrder = true;
									break;
								}
								if (checkTicket(targetThread, fullInvoker.getInvokes(), invContext.getInvocationTicket())) {
									inOrder = true;
									break;
								}
							}
						}
						if (inOrder) {
							targetInvocation = fullInvoker;
						}
					}
				}
			}
		} catch (Exception e) {
			LoadersUtils.log(e);
		}
		return targetInvocation;
	}
	/**
	 * Resolves the links to posible target invocations, invocation that were
	 * received before the invoker (sourceInvocation)
	 */
	private void updateForwardInvokes(TRCMethodInvocation sourceInvocation) {
		//        InvocationContext source;
		UnresolvedCorrelation unresolvedCorrelation = (UnresolvedCorrelation) LookupServiceExtensions.getInstance().locate(null, UnresolvedCorrelationImpl.class, /*
																																								   * context.getNode().getRuntimeId() +
																																								   * "/" +
																																								   * context.getProcessProxy().getRuntimeId() +
																																								   * "/" +
																																								   */
		context.getAgent().getRuntimeId() + "/" + threadIdRef + "/" + ticket + "/" + sequenceCounter);
		if (unresolvedCorrelation != null) {
			for (Iterator iterator = unresolvedCorrelation.getSourceInfos().iterator(); iterator.hasNext();) {
				CorrelationSourceInfo correlationSourceInfo = (CorrelationSourceInfo) iterator.next();
				EReference reference = correlationSourceInfo.getReference();
				EObject owner = correlationSourceInfo.getOwner();
				if (owner instanceof TRCMethodInvocation && (reference == TracePackage.eINSTANCE.getTRCMethodInvocation_InvokedBy())) {
					if (sourceInvocation != null) {
						((TRCMethodInvocation) owner).setInvokedBy(sourceInvocation);
						iterator.remove();
					}
				}
			}
			if (unresolvedCorrelation.getSourceInfos().size() == 0) {
				unresolvedCorrelation.setAgent(null);
			}
		}
	}
	/**
	 * Method updateStatisticalInfo.
	 * 
	 * @param invocation
	 * @param method
	 * @param theObject
	 * @param theClass
	 */
	private void updateStatisticalInfo(TRCThread aThread, TRCFullMethodInvocation invoker, TRCFullMethodInvocation invocation, TRCMethod aMethod, TRCFullTraceObject anObject, TRCClass aClass) {
		try {
			aMethod.setCalls(aMethod.getCalls() + 1);
			theProcess.setCalls(theProcess.getCalls() + 1);
			theProcess.setLastEventTime(invocation.getEntryTime());
			if (anObject != null) {
				anObject.setCalls(anObject.getCalls() + 1);
				invokerObjectClass = getExtendedClass(anObject, aClass);
				if (invokerObjectClass != null) {
					invokerObjectClass.setInheritedCalls(invokerObjectClass.getInheritedCalls() + 1);
					invokerObjectClass.getPackage().setInheritedCalls(invokerObjectClass.getPackage().getInheritedCalls() + 1);
					invokerObjectClass.getPackage().getProcess().setInheritedCalls(invokerObjectClass.getPackage().getProcess().getInheritedCalls() + 1);
				}
			}
			aClass.setCalls(aClass.getCalls() + 1);
			aClass.getPackage().setCalls(aClass.getPackage().getCalls() + 1);
			if (invoker != null) {
				int size = invoker.getInvokes().size();
				if (size > 1) {
					previousSiblingExitTime = ((TRCFullMethodInvocation) invoker.getInvokes().get(size - 2)).getExitTime();
					deltaBaseTime = invocation.getEntryTime() - previousSiblingExitTime;
				} else {
					//this is first call from "invoker" to "invocation"
					deltaBaseTime = invocation.getEntryTime() - invoker.getEntryTime();
				}
				invokerObject = (TRCFullTraceObject) invoker.getOwningObject();
				invokerMethod = invoker.getMethod();
				invokerClass = invoker.getMethod().getDefiningClass();
				invokerObjectClass = getExtendedClass(invokerObject, invokerClass);
				//update base and cumulative using deltaBaseTime, invokerObject
				// and invokerClass
				updateTimeStatistics();
			}
		} catch (Exception e) {
			LoadersUtils.log(e);
		}
	}
	/**
	 * Method updateStatisticalInfoOnly.
	 */
	private void updateStatisticalInfoOnly(TRCMethod aMethod, TRCFullTraceObject anObject, TRCClass aClass, TRCThread aThread, double entryTime) {
		InvocationInfo invoker = null;
		if (!cs.isEmpty()) {
			invoker = (InvocationInfo) cs.peek();
		}
		updateStatisticalInfoOnlyExtra(invoker, entryTime, aMethod, anObject, aClass);
		cs.push(invocationPool.allocInvocation(cs, anObject, aClass, aMethod, entryTime));
		theProcess.setCalls(theProcess.getCalls() + 1);
		theProcess.setLastEventTime(entryTime);
	}
	private void updateStatisticalInfoOnlyExtra(InvocationInfo invoker, double entryTime, TRCMethod aMethod, TRCFullTraceObject anObject, TRCClass aClass) {
		try {
			aMethod.setCalls(aMethod.getCalls() + 1);
			if (anObject != null) {
				anObject.setCalls(anObject.getCalls() + 1);
				invokerObjectClass = getExtendedClass(anObject, aClass);
				if (invokerObjectClass != null) {
					invokerObjectClass.setInheritedCalls(invokerObjectClass.getInheritedCalls() + 1);
					invokerObjectClass.getPackage().setInheritedCalls(invokerObjectClass.getPackage().getInheritedCalls() + 1);
					invokerObjectClass.getPackage().getProcess().setInheritedCalls(invokerObjectClass.getPackage().getProcess().getInheritedCalls() + 1);
				}
			}
			aClass.setCalls(aClass.getCalls() + 1);
			aClass.getPackage().setCalls(aClass.getPackage().getCalls() + 1);
			aClass.getPackage().getProcess().setCalls(aClass.getPackage().getProcess().getCalls() + 1);
			if (invoker != null) {
				previousSiblingExitTime = invoker.getLastChildExitTime();
				if (previousSiblingExitTime > 0) {
					deltaBaseTime = entryTime - previousSiblingExitTime;
				} else {
					//this is first call from "invoker" to "invocation"
					deltaBaseTime = entryTime - invoker.getEntryTime();
				}
				invokerObject = invoker.getObject();
				invokerClass = invoker.getTheClass();
				invokerObjectClass = invoker.getObjectClass();
				invokerMethod = invoker.getMethod();
				//update base and cumulative using deltaBaseTime, invokerObject
				// and invokerClass
				updateTimeStatistics();
			}
		} catch (Exception e) {
			LoadersUtils.log(e);
		}
	}
}