/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.ui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import org.eclipse.hyades.test.common.event.InvocationEvent;
import org.eclipse.hyades.test.common.event.TypedEvent;
import org.eclipse.hyades.test.common.event.VerdictEvent;
import org.eclipse.hyades.test.common.util.BaseString;
import org.eclipse.hyades.test.manual.runner.RemoteAppResourceBundle;
import org.eclipse.hyades.test.manual.runner.model.IVerdictListener;
import org.eclipse.hyades.test.manual.runner.model.Loop;
import org.eclipse.hyades.test.manual.runner.model.TestCase;
import org.eclipse.hyades.test.manual.runner.model.TestInvocation;
import org.eclipse.hyades.test.manual.runner.model.TestSuite;
import org.eclipse.hyades.test.manual.runner.model.util.ModelUtil;
import org.eclipse.hyades.test.manual.runner.model.util.Verdict;
import org.eclipse.hyades.test.manual.runner.ui.util.SwingUtil;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class TestInvocationExecutionPanel
extends BasePanel implements IVerdictListener
{
	private JComboBox verdictCombo;
	private JTextArea infoText;
	private JButton doneButton;
	
	/**
	 * Constructor for TestInvocationExecutionPanel
	 */
	public TestInvocationExecutionPanel()
	{
		TestInvocation.addListener(this);
	}
	
	/**
	 * @see BasePanel#createControl()
	 */
	protected void createControl()
	{
		setLayout(new BorderLayout(0, 5));
		setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));

		JPanel northPanel = new JPanel(new GridLayout(0, 1, 0, 3));
		add(northPanel, BorderLayout.NORTH);

		JPanel centerPanel = new JPanel();
		centerPanel.setLayout(new BoxLayout(centerPanel, BoxLayout.Y_AXIS));
		add(centerPanel, BorderLayout.CENTER);

		verdictCombo = new JComboBox();
		verdictCombo.setAlignmentX(Component.LEFT_ALIGNMENT);
		verdictCombo.setPreferredSize(new JTextField().getPreferredSize());
		verdictCombo.setEditable(false);		
		for (Iterator i = ModelUtil.getVerdicts().iterator(); i.hasNext();)
			verdictCombo.addItem(i.next());
		
		JLabel label = new JLabel(RemoteAppResourceBundle.getString("label.Status"));
		label.setLabelFor(verdictCombo);
		label.setAlignmentX(Component.LEFT_ALIGNMENT);
		SwingUtil.adjustMnemonic(label);
		
		northPanel.add(label);
		northPanel.add(verdictCombo);

		infoText = new JTextArea(3, 0);
		infoText.setRequestFocusEnabled(true);
		label = new JLabel(RemoteAppResourceBundle.getString("label.Info"));
		label.setLabelFor(infoText);
		label.setAlignmentX(Component.LEFT_ALIGNMENT);
		SwingUtil.adjustMnemonic(label);	
		JScrollPane infoScrollPane = new JScrollPane(infoText, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		infoScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);

		centerPanel.add(label);
		centerPanel.add(Box.createRigidArea(new Dimension(0,5)));
		centerPanel.add(infoScrollPane);
		
		doneButton = new JButton();
		doneButton.setText(RemoteAppResourceBundle.getString("action.NextTask"));
		SwingUtil.adjustMnemonic(doneButton);
		doneButton.setToolTipText(RemoteAppResourceBundle.getString("button.done.Description"));
		doneButton.setAlignmentY(Component.RIGHT_ALIGNMENT);
		doneButton.addActionListener(this);
		
		JPanel southPanel = new JPanel();
		southPanel.setLayout(new BoxLayout(southPanel, BoxLayout.X_AXIS));
		add(southPanel, BorderLayout.SOUTH);
		
		southPanel.add(Box.createHorizontalGlue());
		southPanel.add(doneButton);
	}
	
	/**
	 * @see BasePanel#isValidData(Object)
	 */
	protected boolean isValidData(Object data)
	{
		if(data instanceof TestInvocation)
		{
			TestInvocation testInvocation = (TestInvocation)data;
			if(testInvocation.getTest() != null)
			{
				if(testInvocation.getTest() instanceof TestCase)
					return true;
					
				TestSuite testSuite = (TestSuite)testInvocation.getTest();
				return !(testSuite.getActions().isEmpty());
			}
		}
		return false;
	}

	/**
	 * @see BasePanel#invalidData()
	 */
	protected void invalidData()
	{
		infoText.setText("");
	}
	
	/**
	 * @see BasePanel#refreshPanel(boolean)
	 */
	protected void refreshPanel(boolean sameObject)
	{
		if(getTestInvocation().getVerdictEvent() != null)
		{
			verdictCombo.setSelectedItem(ModelUtil.getVerdict(getTestInvocation().getVerdictEvent().getVerdict()));
			infoText.setText(BaseString.toString(getTestInvocation().getVerdictEvent().getText()));
		}
		else
		{
			verdictCombo.setSelectedItem(ModelUtil.getDefaultVerdict());
			infoText.grabFocus();
			infoText.requestFocus();
			infoText.setText(null);
		}
	}

	/**
	 * @see BasePanel#setEditable(boolean)
	 */
	protected void setEditable(boolean editable)
	{
		verdictCombo.setEnabled(editable);
		doneButton.setEnabled(editable && (getTestInvocation().getTest() != null));
		
		infoText.setEditable(editable);
		JTextField dummy = new JTextField();
		dummy.setEditable(editable);
		infoText.setBackground(dummy.getBackground());
	}
			
	public TestInvocation getTestInvocation()
	{
		return (TestInvocation)getCurrentData();
	}	
	
	/**
	 * @see BasePanel#updateCurrentData(EventObject)
	 */
	public void updateCurrentData(EventObject event)
	{
		if(event.getSource() == doneButton)
		{
			if(verdictCombo.getSelectedItem() != null)
			{
				if(getTestInvocation().getExecutionCount() == 0)
				{
					if(getTestInvocation().getTest() instanceof TestCase)
					{
						TestSuite testSuite = ((TestCase)getTestInvocation().getTest()).getTestSuite();
						if(testSuite.getTestInvocation() != null)
						{
							TestInvocation suiteInvocation = testSuite.getTestInvocation();
							Collection executedTestInvocations = ModelUtil.DEFAULT_EXECUTION_MANAGER.getExecutedTestInvocations();
							if(!executedTestInvocations.contains(suiteInvocation))
							{
								executedTestInvocations.add(suiteInvocation);
								
								ModelUtil.getEventLogger().logInvocation(suiteInvocation, InvocationEvent.STATUS_SUCCESSFUL, null);
								
								TypedEvent typedEvent = ModelUtil.createTestTypedEvent(suiteInvocation);
								typedEvent.setType(TypedEvent.START);
								ModelUtil.getEventLogger().log(typedEvent);								
							}
						}
					}
					
					if(getTestInvocation().getOwner() instanceof Loop)
						ModelUtil.DEFAULT_EXECUTION_MANAGER.startLoop((Loop)getTestInvocation().getOwner());
					
					ModelUtil.getEventLogger().logInvocation(getTestInvocation(), InvocationEvent.STATUS_SUCCESSFUL, null);
					
					TypedEvent typedEvent = ModelUtil.createTestTypedEvent(getTestInvocation());
					typedEvent.setType(TypedEvent.START);
					ModelUtil.getEventLogger().log(typedEvent);
				}

				VerdictEvent verdictEvent = ModelUtil.createTestVerdictEvent(getTestInvocation());
				verdictEvent.setVerdict(((Verdict)verdictCombo.getSelectedItem()).getValue());				
				if((infoText.getText() != null) && (infoText.getText().trim().length() > 0))
				{
					verdictEvent.setText(infoText.getText());
					verdictEvent.setReason(VerdictEvent.REASON_SEE_DESCRIPTION);
				}
				ModelUtil.getEventLogger().log(verdictEvent);

				getTestInvocation().setVerdictEvent(verdictEvent);
			}
		}
	}
	
	/**
	 * @see org.eclipse.hyades.test.manual.runner.model.IVerdictListener#handleVerdict(org.eclipse.hyades.test.manual.runner.model.TestInvocation)
	 */
	public void handleVerdict(TestInvocation testInvocation)
	{
		if(getTestInvocation() == testInvocation)
			setEditable(infoText.isEditable());
	}
}