/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.editors;

import java.util.*;

import org.eclipse.emf.common.util.*;
import org.eclipse.emf.ecore.*;
import org.eclipse.hyades.models.internal.sdb.*;
import org.eclipse.hyades.models.internal.sdb.impl.*;
import org.eclipse.hyades.sdb.internal.*;
import org.eclipse.hyades.sdb.internal.help.*;
import org.eclipse.hyades.sdb.internal.util.*;
import org.eclipse.swt.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.help.*;

public class SolutionDetails extends Composite implements IDetails, Listener {

	private Text txtInfo;
	private CCombo cmbSolution;
	private ArrayList solutionRegistry = null;
	private SymptomDBEditor editor;
	private SDBFactoryImpl objFactory = null;
	private SDBSolution currentSel = null;
	private boolean isDisplaying = false;

	public SolutionDetails(
		RASWidgetFactory factory,
		Composite composite,
		int style) {

		super(composite, style);
		GridLayout solLayout = new GridLayout();
		solLayout.numColumns = 1;

		this.setLayout(solLayout);
		this.setLayoutData(GridUtil.createFill());

		Label lblSolution =
			factory.createLabel(
				this,
				SDbPlugin.getResourceString("STR_SOLUTION_LABEL"),
				SWT.NONE);
		cmbSolution = factory.createCombo(this, SWT.READ_ONLY);
		GridData cmbGrid = new GridData(GridData.FILL_HORIZONTAL);
		cmbGrid.widthHint = 350;
		cmbSolution.setLayoutData(cmbGrid);

		factory.createCompositeSeparator(this);

		Label lblInfo =
			factory.createLabel(
				this,
				SDbPlugin.getResourceString("STR_SI_DETAILS_LABEL"),
				SWT.NONE);
		GridData lblInfoGrid = new GridData(GridData.FILL_HORIZONTAL);
		lblInfo.setLayoutData(lblInfoGrid);

		txtInfo =
			factory.createText(
				this,
				"",
				RASWidgetFactory.BORDER_STYLE | SWT.V_SCROLL | SWT.H_SCROLL | SWT.MULTI);
		GridData infoGrid = new GridData(GridData.FILL_BOTH);
		infoGrid.heightHint = 45;
		infoGrid.widthHint = 350;
		infoGrid.verticalSpan = 3;
		txtInfo.setLayoutData(infoGrid);

		WorkbenchHelp.setHelp(cmbSolution, ContextIds.SYMDB_EDITOR_SOLUTION);
		WorkbenchHelp.setHelp(txtInfo, ContextIds.SYMDB_EDITOR_SOLUTION_DESCRIPTION);

		// add listeners - don't change the order in which the listeners are added
		// because of team support issues modify listeners should always be the last one added
		cmbSolution.addListener(SWT.Selection, this);
		txtInfo.addListener(SWT.Modify, this);
	}
	public void init(SymptomDBEditor editor) {
		this.editor = editor;
		objFactory = SDbPlugin.getDefault().getSDBFactory();
		EList solutions = editor.getModel().getSolutions();
		cmbSolution.add(SDbPlugin.getResourceString("STR_NEW_SOLUTION_LABEL"));
		for (int i = 0; i < solutions.size(); i++) {
			cmbSolution.add(
				getFirstNonBlankLineFrom(((SDBSolution) solutions.get(i)).getDescription()));
		}

		solutionRegistry = new ArrayList();
		SDBSolution newSol = objFactory.createSDBSolution();
		newSol.setDescription(SDbPlugin.getResourceString("STR_NEW_SOLUTION_LABEL"));
		solutionRegistry.add(0, newSol);
		solutionRegistry.addAll(solutions);
	}
	public void display(EObject object) {
		isDisplaying = true;
		currentSel = (SDBSolution) object;

		if (solutionRegistry.indexOf(currentSel) > -1) {
			txtInfo.setText(currentSel.getDescription());
			cmbSolution.setText(getFirstNonBlankLineFrom(currentSel.getDescription()));
			cmbSolution.setEnabled(false);
		} else {
			txtInfo.setText(currentSel.getDescription());
			cmbSolution.setEnabled(true);
			cmbSolution.select(0);
		}
		isDisplaying = false;
	}
	public void setFocusToTextBox() {
		txtInfo.setFocus();
		txtInfo.setSelection(0, txtInfo.getText().length());
	}
	public void handleEvent(Event e) {
		Widget source = e.widget;

		if (source == cmbSolution || source == txtInfo) {

			boolean status = false;
			if (source == cmbSolution) {

				int i = cmbSolution.getSelectionIndex();
				txtInfo.setText(((SDBSolution) solutionRegistry.get(i)).getDescription());

				currentSel = (SDBSolution) solutionRegistry.get(i);
			}
			
			if(source == txtInfo && isDisplaying == false){
				status = editor.validateState(txtInfo, this, currentSel.getDescription());
			}

			if (currentSel != null && isDisplaying == false && status == true) {
				editor.updateUIDirtyStatus(true);
				editor.updateModelDirtyStatus(true);
			}
		}
	}
	public boolean updateCurrentSelection(EObject currentSelection) {

		if (cmbSolution.getSelectionIndex() == 0) {
			currentSel = (SDBSolution) currentSelection;
			currentSel.setDescription(txtInfo.getText());

			if (solutionRegistry.indexOf(currentSel) < 0) {
				updateSolutionRegistry(currentSel, true);
			}

		} else {

			if (cmbSolution.isEnabled()) {

				SDBSymptom parent = (SDBSymptom) editor.detailsPage.getParentOfCurrentSel();
				SDBRuntime db = (SDBRuntime) editor.detailsPage.getTreeRoot();
				updateSolutionRegistry(currentSel, false);
				currentSel.setDescription(txtInfo.getText());
				((SDBSymptom) parent).getSolutions().add(currentSel);
				currentSel.getSymptoms().add((SDBSymptom) parent);
				updateSolutionRegistry(currentSel, true);
				removeNewSolution((SDBSolution) currentSelection, parent, db);

			} else {
				updateSolutionRegistry(currentSel, false);
				currentSel = (SDBSolution) currentSelection;
				currentSel.setDescription(txtInfo.getText());
				updateSolutionRegistry(currentSel, true);
			}
		}
		return true;
	}

	/*protected boolean validate(){
	
		if(txtInfo.getText().length()==0){
	    	MessageDialog.openError(Display.getCurrent().getActiveShell(),
	                                       "Invalid solution description",
	                                       "The solution description should have at least one character");
	        return false;                               
		}
	
		TRCSymptom parent = (TRCSymptom)editor.detailsPage.getParentOfCurrentSel();
		
		for(int i=0;i<parent.getSolutions().size();i++){
			TRCSolution current = (TRCSolution)parent.getSolutions().get(i);
			if(current.getDescription().equals(txtInfo.getText())) {
		        MessageDialog.openError(Display.getCurrent().getActiveShell(),
		                                       "Duplicate solution",
		                                       "The symptom already contains this solution");
		        return false;
			}
		}
			
		
		if(cmbSolution.getText().equals("<new solution>")&&cmbSolution.indexOf(txtInfo.getText())>-1){
	    	MessageDialog.openError(Display.getCurrent().getActiveShell(),
	                                       "Invalid solution description",
	                                       "A solution with the same description already exists in the database");
	        return false;                               
		}
	
		if(!cmbSolution.getText().equals("<new solution>") && !cmbSolution.getText().equals(txtInfo.getText()) && (cmbSolution.indexOf(txtInfo.getText())>-1)){
	    	MessageDialog.openError(Display.getCurrent().getActiveShell(),
	                                       "Invalid solution description",
	                                       "A solution with the same description already exists in the database");
	        return false;                               
		}
	
		
		return true;
		                                      		
	}*/

	protected void updateSolutionRegistry(SDBSolution object, boolean add) {
		if (add) {
			solutionRegistry.add(object);
			cmbSolution.add(getFirstNonBlankLineFrom(object.getDescription()));
		} else {
			if(solutionRegistry.indexOf(object)>-1){
				cmbSolution.remove(solutionRegistry.indexOf(object));
				solutionRegistry.remove(object);				
			}
		}
	}
	private void removeNewSolution(
		SDBSolution current,
		SDBSymptom parent,
		SDBRuntime root) {

		parent.getSolutions().remove(current);
		root.getSolutions().remove(current);
		current.getSymptoms().remove(parent);
		solutionRegistry.remove(current);
	}
	protected ArrayList getSolutionRegistry() {
		return solutionRegistry;
	}
	private String getFirstNonBlankLineFrom(String description) {

		String nl = "\r\n";
		if (description.indexOf("\r\n") < 0)
			if (description.indexOf("\n") < 0) {
				return description;
			} else {
				nl = "\n";
			}

		int i = 0;
		int j = 0;
		String line = "";
		while (i <= description.length()) {

			if ((j = description.indexOf(nl, i)) > -1) {
				line = description.substring(i, j);
				if (!line.equals(""))
					break;
			} else {
				line = description.substring(i);
				break;
			}
			i = j + nl.length();
		}
		return line;
	}
}
