/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon;

import org.eclipse.ui.*;
import org.eclipse.ui.plugin.*;
import org.eclipse.core.runtime.*;
import java.util.*;

import org.eclipse.hyades.statistical.ui.*;

import java.lang.reflect.*;

/**
 * The main plugin class to be used in the desktop.
 */
public class PerfmonPlugin extends AbstractUIPlugin {
		
	public static Debugger DBG = new Debugger("org.eclipse.hyades.perfmon");
	
	//The shared instance.
	private static PerfmonPlugin plugin;
	//Resource bundle.
	private static ResourceBundle resourceBundle;
	
	public static ImageManager img = new ImageManager();

	
	public static void disposeObject(Object o) throws Throwable {
		Class c = o.getClass();

		Throwable error = null;
		
		while (c != null) {				
			try {
				Method o_dispose = c.getDeclaredMethod("dispose",new Class[]{});
				o_dispose.setAccessible(true);
				o_dispose.invoke(o,new Object[]{});
				error = null;
				break;
			} catch (Throwable e) { 
				error = e;
			}
			c = c.getSuperclass();
		}
		
		if (error != null) throw error;
	}

	public static IWorkbenchPage getActivePage() {
		IWorkbench workbench = PlatformUI.getWorkbench();
		IWorkbenchPage activePage = null;
		if(workbench.getActiveWorkbenchWindow() != null)
		{
			activePage = workbench.getActiveWorkbenchWindow().getActivePage();
		}
		else if(workbench.getWorkbenchWindows().length > 0)
		{
			for (int i = 0; i < workbench.getWorkbenchWindows().length; i++) {
				activePage = workbench.getWorkbenchWindows()[i].getActivePage();
				//got an active page
				if (activePage != null) break;
			}
		}
		
		return activePage;
	}

	/**
	 * Returns the shared instance.
	 */
	public static PerfmonPlugin getDefault() {
		return plugin;
	}
	
	/**
	 * The constructor.
	 */
	public PerfmonPlugin ()
	{
		super();
		plugin = this;
		
		DBG.setPlugin(this);
		
//		resourceBundle = this.getDescriptor().getResourceBundle();

		plugin = this;

//		resourceBundle = getResourceBundle();

		img.initialize("icons/",this,"org.eclipse.hyades.perfmon");
/*		
		try {
			PerfmonPlugin.DBG.info("initializing images");
			img.initialize(new URL(getDescriptor().getInstallURL(),"icons/"), ImageRegistryProvider.createImageRegistry());
			img.addImages();
		} catch (Exception e) {
			e.printStackTrace();
		}
*/
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
//	public ResourceBundle getResourceBundle() {
//		return resourceBundle;
//	}
	
	/**
	 * 
	 * @param key property key
	 * @return the string associated woth this key
	 */
	public static String getString(String key) 
	{
		try
		{
			if (resourceBundle == null) {
				resourceBundle = Platform.getResourceBundle(getDefault().getBundle());
			}
			return resourceBundle.getString(key);
		}
		catch (NullPointerException e)
		{
			return key;
		}
		catch (MissingResourceException e)
		{
			return key;
		}
	}
	
	/**
	 * Returns the string value associate to a given key.  The key is passed to
	 * each resource bundle in the order they are retrieve by the 
	 * {@link #iterator()} method.
	 * 
	 * <p>The <code>arg</code> string defined replaces the %1 
	 * variable defined in the file's values.
	 * 
	 * <p>Example: If the value associated to the key <code>"a"</code> is 
	 * <code>"%0 %1 %2 %3 %4"</code> and arg is <code>"v1"</code>,
	 * the return of this method is <code>"%0 v1  %2 %3 %4"</code>.
	 * 
	 * @param key
	 * @param arg
	 * @return String
	 * @throws java.util.MissingResourceException if the key is not in the file
	 * @throws NullPointerException if key is null
	 */
	public String getString(String key, String arg)
	{
		try {
			if (resourceBundle == null) {
				resourceBundle = Platform.getResourceBundle(getBundle());
			}
			return resourceBundle.getString(key);
		} catch (NullPointerException e) {
			return key;
		} catch (MissingResourceException e) {
			return key;
		}	
	}
}
