/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class RefreshFromLocalAction
extends SelectionProviderAction
implements ISelectionChangedListener {
    private INavigator fViewer;

    public RefreshFromLocalAction(INavigator viewer) {
        super((ISelectionProvider)viewer.getViewer(), UIPlugin.getResourceString("RELOAD"));
        this.setDescription(UIPlugin.getResourceString("RELOAD_LOCAL_FILE"));
        this.fViewer = viewer;
        WorkbenchHelp.setHelp((IAction)this, (String)(UIPlugin.getPluginId() + ".refl0000"));
        this.setToolTipText(UIPlugin.getResourceString("RELOAD_LOCAL_FILE_TOOLTIP"));
    }

    public void run() {
        String title = UIPlugin.getResourceString("TRACE_MSG");
        String msg = UIPlugin.getResourceString("RELOAD_QUESTION");
        if (!MessageDialog.openQuestion((Shell)this.fViewer.getViewSite().getShell(), (String)title, (String)msg)) {
            return;
        }
        ProfileEvent event = new ProfileEvent();
        event.setSource(ResourcesPlugin.getWorkspace().getRoot());
        this.handleResources();
        event.setType(5120);
        UIPlugin.getDefault().notifyProfileEventListener(event);
        if (!(this.fViewer instanceof PDProjectExplorer)) {
            event.setType(4608);
            UIPlugin.getDefault().notifyProfileEventListener(event);
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(true);
    }

    public void dispose() {
        super.dispose();
        this.fViewer = null;
    }

    private void handleResources() {
        PDContentProvider.resetMonitors();
        Object[] resources = HierarchyResourceSetImpl.getInstance().getResources().toArray();
        for (int idx = 0; idx < resources.length; ++idx) {
            Resource element = (Resource)resources[idx];
            if (element == null || !element.isLoaded()) continue;
            Object[] elements = element.getContents().toArray();
            for (int i = 0; i < elements.length; ++i) {
                Object obj = elements[i];
                ArrayList deletelist = UIPlugin.getDefault().getDeleteListeners();
                for (int j = 0; j < deletelist.size(); ++j) {
                    ((IDeleteListener)deletelist.get(j)).deregister(obj);
                }
                element.unload();
            }
        }
    }
}

