/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer.dumpparser;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.TaException;
import org.eclipse.hyades.collection.threadanalyzer.Thd;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser;

public class DumpParserSolaris40
extends DumpParser {
    public void parse(DumpData d) throws Exception {
        try {
            if (this._r.ready()) {
                this.getThreadData(d);
                while (this.getLine(d) != null) {
                }
            }
        }
        catch (Exception e) {
            DumpParserSolaris40.logErr(TAUtils.getNLSValue("ta.errmsg.ExceptionWhileParsing", "exception while parsing line") + ": " + this._lineNo + " -- " + _dumpInName);
            throw new TaException("" + this._lineNo, e);
        }
    }

    private void getThreadData(DumpData d) throws Exception {
        this.readToDump();
        String line = null;
        char firstChar = '\u0000';
        line = this.getLine(d);
        line = this.getLine(d);
        Thd thd = null;
        while (this._r.ready()) {
            StringTokenizer st;
            String line2;
            firstChar = line.length() > 0 ? line.charAt(0) : (char)'\u0000';
            if (line.indexOf("FOUND A JAVA LEVEL DEADLOCK:") != -1) break;
            if (firstChar == '\"') {
                int idx1 = line.indexOf(34);
                int idx2 = line.indexOf(34, idx1 + 1);
                String thdNm = line.substring(idx1 + 1, idx2);
                StringTokenizer st2 = new StringTokenizer(line.substring(idx2 + 1));
                String line22 = st2.nextToken();
                line22 = st2.nextToken();
                String priority = line22.substring(5);
                line22 = st2.nextToken();
                String threadId = line22.substring(4);
                line22 = st2.nextToken();
                String state = new String();
                while (st2.hasMoreTokens()) {
                    line22 = st2.nextToken();
                    if (line22.charAt(0) == '[') continue;
                    state = state + " " + line22;
                }
                thd = d.addThd(thdNm, threadId, state, priority);
            } else if (firstChar == '\t' && !(line2 = new String((st = new StringTokenizer(line)).nextToken())).equals("-")) {
                line2 = st.nextToken();
                if (st.hasMoreTokens()) {
                    line2 = line2 + " " + st.nextToken();
                }
                boolean isNative = false;
                String moduleName = null;
                String lineno = null;
                int idx1 = line2.indexOf("(Native Method)");
                if (idx1 > 0) {
                    isNative = true;
                    line2 = line2.substring(0, idx1);
                } else {
                    idx1 = line2.indexOf("(");
                    String moduleInfo = line2.substring(++idx1);
                    line2 = line2.substring(0, idx1 - 1);
                    int idx2 = moduleInfo.indexOf(58);
                    if (idx2 > 0) {
                        lineno = moduleInfo.substring(idx2 + 1, moduleInfo.indexOf(41, idx2));
                        moduleName = moduleInfo.substring(0, idx2);
                    } else {
                        idx2 = moduleInfo.indexOf(41);
                        moduleName = moduleInfo.substring(0, idx2);
                    }
                }
                String method = line2.substring(line2.lastIndexOf(46) + 1);
                String pkg = line2.substring(0, line2.lastIndexOf(46));
                int iLineNo = -1;
                if (lineno != null) {
                    iLineNo = Integer.parseInt(lineno);
                }
                StkEntry se = new StkEntry(method, pkg, moduleName, iLineNo, isNative);
                thd.addStackEntry(se);
            }
            line = this.getLine(d);
        }
    }

    private void readToDump() {
        int lineNo = 0;
        int matchAt = -1;
        try {
            String str1;
            while (this._r.ready()) {
                str1 = this._r.readLine();
                ++lineNo;
                if (str1.indexOf("Full thread dump") <= -1) continue;
                matchAt = lineNo;
                break;
            }
            if (matchAt > -1) {
                this._r.close();
                this._r = new BufferedReader(new FileReader(_dumpInName));
                str1 = null;
                for (lineNo = 0; lineNo < matchAt; ++lineNo) {
                    str1 = this._r.readLine();
                }
            }
        }
        catch (IOException ioe) {
            DumpParserSolaris40.logErr(TAUtils.getNLSValue("ta.errmsg.ErrReading", "error reading") + " " + "stderr");
            System.exit(-1);
        }
    }
}

