/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.recorder.ui.actions;

import org.eclipse.hyades.execution.recorder.RecorderPlugin;
import org.eclipse.hyades.internal.execution.recorder.RecorderFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.actions.IRecorderAction;
import org.eclipse.hyades.internal.execution.recorder.ui.wizards.RecorderWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class AbstractNewRecordingAction
extends Action
implements IWorkbenchWindowActionDelegate,
IRecorderAction {
    private IAction toolbarAction = null;

    public AbstractNewRecordingAction() {
        RecorderFactory.getInstance().addListener(this);
    }

    public AbstractNewRecordingAction(String string) {
        super(string);
        RecorderFactory.getInstance().addListener(this);
    }

    public AbstractNewRecordingAction(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
        RecorderFactory.getInstance().addListener(this);
    }

    public AbstractNewRecordingAction(String string, int n) {
        super(string, n);
        RecorderFactory.getInstance().addListener(this);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
    }

    public void run(IAction iAction) {
        iAction = this.toolbarAction;
        this.run();
    }

    public void run() {
        RecorderWizard recorderWizard = this.loadWizard();
        recorderWizard.init(this.getWorkbench(), this.getSelection());
        WizardDialog wizardDialog = new WizardDialog(this.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)recorderWizard);
        wizardDialog.open();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.toolbarAction = iAction;
    }

    public abstract RecorderWizard loadWizard();

    protected IWorkbench getWorkbench() {
        return RecorderPlugin.getDefault().getWorkbench();
    }

    protected IStructuredSelection getSelection() {
        ISelection iSelection;
        IWorkbenchWindow iWorkbenchWindow = RecorderPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iSelection = iWorkbenchWindow.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)iSelection;
        }
        return null;
    }

    public void updateRecorderStatus(boolean bl) {
        this.setEnabled(!bl);
        if (this.toolbarAction != null) {
            this.toolbarAction.setEnabled(!bl);
        }
    }
}

