/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.lang.reflect.Method;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.FeatureNode;
import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.log.ui.internal.util.TerminalNode;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.hierarchy.util.IFilterElement;
import org.eclipse.jface.preference.IPreferenceStore;

public class RecordFilterSearchUtil {
    private HashMap _methods = new HashMap();
    private ElementFilter _filter;
    private Collator collator = Collator.getInstance();
    static /* synthetic */ Class class$java$lang$String;

    public RecordFilterSearchUtil() {
        this._filter = new ElementFilter();
    }

    public void dispose() {
        this._methods.clear();
    }

    public boolean isAdvFilterApply(EObject logRecord, IFilterElement[] filterTableElements) {
        if (filterTableElements == null) {
            return true;
        }
        EClass eClass = logRecord.eClass();
        EList attributes = eClass.getEAllAttributes();
        boolean filterApply = true;
        int l = filterTableElements.length;
        for (int idx = 0; idx < l; ++idx) {
            IFilterElement filterTableElement = filterTableElements[idx];
            String elemAttribute = filterTableElement.getAttribute().toLowerCase();
            EAttribute attribute = this.findAttributeInList(elemAttribute, attributes);
            if (attribute != null) {
                filterApply &= this.matchFilter(logRecord, attribute, filterTableElement);
                continue;
            }
            filterApply &= this.checkChildren(logRecord, elemAttribute, filterTableElement);
        }
        return filterApply;
    }

    public EAttribute findAttributeInList(String name, EList attributeList) {
        for (int i = 0; i < attributeList.size(); ++i) {
            EAttribute attr = (EAttribute)attributeList.get(i);
            if (!attr.getName().toLowerCase().equals(name)) continue;
            return attr;
        }
        return null;
    }

    private boolean matchFilter(EObject logRecord, EAttribute attribute, IFilterElement filterTableElement) {
        Object value = logRecord.eGet((EStructuralFeature)attribute);
        String filterTableValue = filterTableElement.getValue();
        String filterTableOperator = filterTableElement.getOperator();
        if (value == null) {
            value = new String("");
        }
        if (filterTableValue == null) {
            filterTableValue = new String("");
        }
        if (attribute.getName().equals("creationTime")) {
            value = this.formatCreationTime(value, logRecord.getClass(), logRecord);
        }
        if (filterTableOperator.equals(LogUIPlugin.getResourceString("STR_EQUAL"))) {
            return this.checkEqual(value.toString(), filterTableValue);
        }
        if (filterTableOperator.equals(LogUIPlugin.getResourceString("STR_NOT_EQUAL"))) {
            return this.checkNotEqual(value.toString(), filterTableValue);
        }
        if (filterTableOperator.equals(LogUIPlugin.getResourceString("STR_LARGER_THAN"))) {
            return this.checkLargerThan(value.toString(), filterTableValue);
        }
        if (filterTableOperator.equals(LogUIPlugin.getResourceString("STR_SMALLER_THAN"))) {
            return this.checkSmallerThan(value.toString(), filterTableValue);
        }
        return false;
    }

    private Object formatCreationTime(Object l, Class clsName, Object element) {
        String res = "0";
        CBECommonBaseEvent event = (CBECommonBaseEvent)element;
        if (event.getCreationTime() != 0.0) {
            try {
                short value = 0;
                try {
                    Method method = this.getMethod(clsName, "getTimeZone");
                    if (method != null) {
                        value = (Short)method.invoke(element, null);
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
                double ct = CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)event);
                Double l2 = new Double(ct);
                SimpleDateFormat dateFormat = this.getDateTimeFormat();
                res = dateFormat.format(new Date(l2.longValue() / 1000L + (long)(value * 60 * 1000)));
                String microseconds = "" + l2.longValue() % 1000000L;
                res = res + "." + "000000".substring(0, 6 - microseconds.length()) + microseconds;
                res = res + (value > 0 ? "+00" : "-00").substring(0, 3 - ("" + Math.abs(value / 60)).length()) + Math.abs(value / 60);
                res = res + ":00".substring(0, 3 - ("" + Math.abs(value % 60)).length()) + Math.abs(value % 60);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return res;
    }

    private boolean checkChildren(EObject logRecord, String elemAttribute, IFilterElement filterTableElement) {
        boolean filterApply = true;
        boolean match = true;
        if (logRecord instanceof EObject && logRecord.eClass().getEPackage() == CBEPackage.eINSTANCE) {
            match = false;
            EClass eClass = logRecord.eClass();
            Iterator iter = eClass.getEAllStructuralFeatures().iterator();
            while (iter.hasNext()) {
                Object refs;
                EStructuralFeature feature = (EStructuralFeature)iter.next();
                if ((!(feature instanceof EReference) || feature.getFeatureID() == 3) && (!(feature instanceof EAttribute) || !feature.isMany() || feature.getEType().getInstanceClass() == (class$java$lang$String == null ? RecordFilterSearchUtil.class$("java.lang.String") : class$java$lang$String)) || (refs = logRecord.eGet(feature, true)) == null) continue;
                if (refs instanceof EList) {
                    if (((EList)refs).size() <= 0) continue;
                    Object[] object = ((EList)refs).toArray();
                    for (int i = 0; i < object.length; ++i) {
                        int matchAttri = this.containsAttribute((EObject)object[i], elemAttribute, filterTableElement);
                        if (matchAttri <= 0) continue;
                        match = true;
                        filterApply |= matchAttri == 1;
                    }
                    continue;
                }
                int matchAttri = this.containsAttribute((EObject)refs, elemAttribute, filterTableElement);
                if (matchAttri <= 0) continue;
                match = true;
                filterApply &= matchAttri == 1;
            }
        } else if (logRecord instanceof FeatureNode) {
            EStructuralFeature feature = ((FeatureNode)logRecord).getFeature();
            EObject cElem = ((FeatureNode)logRecord).getElement();
            match = false;
            if (feature instanceof EReference) {
                if (feature.isMany()) {
                    EList refs = (EList)cElem.eGet(feature, true);
                    if (refs.size() > 0) {
                        Object[] object = refs.toArray();
                        for (int i = 0; i < object.length; ++i) {
                            int matchAttri = this.containsAttribute((EObject)object[i], elemAttribute, filterTableElement);
                            if (matchAttri <= 0) continue;
                            match = true;
                            filterApply |= matchAttri == 1;
                        }
                    }
                } else {
                    Object ref = cElem.eGet(feature, true);
                    int matchAttri = this.containsAttribute((EObject)ref, elemAttribute, filterTableElement);
                    if (matchAttri > 0) {
                        match = true;
                        filterApply &= matchAttri == 1;
                    }
                }
            }
        } else if (logRecord instanceof TerminalNode) {
            // empty if block
        }
        return match && filterApply;
    }

    private int containsAttribute(EObject eObject, String elemAttribute, IFilterElement filterTableElement) {
        EClass eClass = eObject.eClass();
        EList attributes = eClass.getEAllAttributes();
        EAttribute attribute = this.findAttributeInList(elemAttribute, attributes);
        if (attribute != null) {
            return this.matchFilter(eObject, attribute, filterTableElement) ? 1 : -1;
        }
        return 0;
    }

    private Method getMethod(Class cls, String name) throws Exception {
        Method method = (Method)this._methods.get(cls.getName() + name);
        if (method == null) {
            method = cls.getMethod(name, null);
            this._methods.put(cls.getName() + name, method);
        }
        return method;
    }

    private SimpleDateFormat getDateTimeFormat() {
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
        String dateFormat = store.getString("LogAnalyzer.DateFormat");
        boolean valid = false;
        for (int i = 0; i < LogUIConstants.DATE_FORMAT_LIST.length; ++i) {
            if (!dateFormat.equals(LogUIConstants.DATE_FORMAT_LIST[i])) continue;
            valid = true;
            break;
        }
        if (!valid) {
            dateFormat = "yyyy-MM-dd";
        }
        String timeFormat = store.getString("LogAnalyzer.TimeFormat");
        valid = false;
        for (int i = 0; i < LogUIConstants.TIME_FORMAT_LIST.length; ++i) {
            if (!timeFormat.equals(LogUIConstants.TIME_FORMAT_LIST[i])) continue;
            valid = true;
            break;
        }
        if (!valid) {
            timeFormat = "HH:mm:ss";
        }
        if (timeFormat.startsWith("h")) {
            timeFormat = timeFormat + " a";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat + " " + timeFormat);
        return formatter;
    }

    private boolean checkEqual(String recordValue, String filterValue) {
        try {
            float recordFloat = Float.parseFloat(recordValue);
            float filterFloat = Float.parseFloat(filterValue);
            return recordFloat == filterFloat;
        }
        catch (NumberFormatException nfe) {
            return this._filter.match(recordValue, filterValue);
        }
    }

    private boolean checkNotEqual(String recordValue, String filterValue) {
        return !this.checkEqual(recordValue, filterValue);
    }

    private boolean checkLargerThan(String recordValue, String filterValue) {
        try {
            float recordFloat = Float.parseFloat(recordValue);
            float filterFloat = Float.parseFloat(filterValue);
            return recordFloat > filterFloat;
        }
        catch (NumberFormatException nfe) {
            int value = this.collator.compare(recordValue, filterValue);
            return value > 0;
        }
    }

    private boolean checkSmallerThan(String recordValue, String filterValue) {
        return !this.checkLargerThan(recordValue, filterValue) && !this.checkEqual(recordValue, filterValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ElementFilter {
        protected String _pattern;
        protected String _prefix = "";
        protected String _suffix = "";
        protected ArrayList _textList;
        protected boolean _caseSensitive = true;
        protected boolean _exactMatch;
        protected boolean _noPattern = true;

        private void setPattern(String pattern, boolean caseSensitive) {
            this._caseSensitive = caseSensitive;
            this._pattern = this._caseSensitive ? pattern : pattern.toLowerCase();
            this._noPattern = pattern == "*" || pattern == "";
            this._exactMatch = this._pattern.indexOf("*") == -1;
            StringTokenizer st = new StringTokenizer(this._pattern, "*");
            this._textList = new ArrayList();
            while (st.hasMoreTokens()) {
                this._textList.add(st.nextToken());
            }
            if (this._pattern.startsWith("*")) {
                this._prefix = "";
            } else if (this._textList.size() > 0) {
                this._prefix = (String)this._textList.get(0);
                this._textList.remove(0);
            }
            if (this._pattern.endsWith("*")) {
                this._suffix = "";
            } else if (this._textList.size() > 0) {
                this._suffix = (String)this._textList.get(this._textList.size() - 1);
                this._textList.remove(this._textList.size() - 1);
            }
        }

        public boolean match(String recordValue, String userValue) {
            this.setPattern(userValue, true);
            boolean flag = true;
            String compareText = "";
            if (this._noPattern) {
                return true;
            }
            compareText = recordValue;
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return RecordFilterSearchUtil.this.collator.compare(compareText, this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                for (int k = 0; k < this._textList.size(); ++k) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.indexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                }
            }
            return flag;
        }
    }
}

