/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.internal.reports;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.test.http.internal.reports.IReportGraphDataProvider;
import org.eclipse.hyades.test.http.runner.HttpResourceBundle;

public abstract class HttpAbstractReport {
    protected TPFExecutionResult result = null;
    protected static ArrayList list = null;
    public static final String responseTimeMarker = HttpResourceBundle.getInstance().getString("PAGERESPONSE_TIME");
    public static final String pageNameMarker = HttpResourceBundle.getInstance().getString("PAGERESPONSE_URL");
    public static final String sysOutTag = "System.out:\n";
    public static final String crlf = "\r\n";
    public static final String lf = "\n";

    public HttpAbstractReport(TPFExecutionResult tPFExecutionResult) {
        this.result = tPFExecutionResult;
    }

    public void generate() {
        list = new ArrayList();
        this.setupReport();
        TPFExecutionHistory tPFExecutionHistory = this.result.getExecutionHistory();
        EList eList = tPFExecutionHistory.getExecutionEvents();
        this.recurseGenerate(eList);
        this.finishReport();
    }

    protected void recurseGenerate(EList eList) {
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            EList eList2;
            Object e = iterator.next();
            if (e instanceof TPFMessageEvent) {
                this.processMessageEvent((TPFMessageEvent)e);
            } else if (e instanceof TPFTypedEvent) {
                this.processTypedEvent((TPFTypedEvent)e);
            }
            if (e instanceof TPFInvocationEvent) {
                eList2 = ((TPFInvocationEvent)e).getInvokedExecutionResult().getExecutionHistory().getExecutionEvents();
                if (eList2.isEmpty()) continue;
                this.recurseGenerate(eList2);
                continue;
            }
            if (!(e instanceof TPFExecutionEvent) || (eList2 = ((TPFExecutionEvent)e).getChildren()).isEmpty()) continue;
            this.recurseGenerate(eList2);
        }
    }

    protected abstract void processMessageEvent(TPFMessageEvent var1);

    protected abstract void processTypedEvent(TPFTypedEvent var1);

    protected abstract void setupReport();

    protected abstract void finishReport();

    public ArrayList getList() {
        return list;
    }

    protected IReportGraphDataProvider findPage(String string) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IReportGraphDataProvider iReportGraphDataProvider = (IReportGraphDataProvider)iterator.next();
            if (!iReportGraphDataProvider.getId().equals(string)) continue;
            return iReportGraphDataProvider;
        }
        return null;
    }
}

