/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Constraint;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.SQLStatement;
import org.eclipse.hyades.resources.database.internal.impl.StatementFactory;

public class SetReferenceCommand
extends DBCommand {
    protected DatabaseType type;
    protected Integer sourceId;
    protected Integer targetId;
    protected EReference reference;
    protected int position;
    private List targets;
    private List positions;
    private Column source;
    private Column target;

    public SetReferenceCommand(JDBCHelper helper, DBMap map, DatabaseType dbType, Integer sourceId, EReference reference, Integer targetId, int position) {
        super(helper, map);
        this.sourceId = sourceId;
        this.reference = reference;
        this.targetId = targetId;
        this.position = position;
    }

    public SetReferenceCommand(JDBCHelper helper, DBMap dbMap, DatabaseType type, Integer source, EReference reference, List targets, List positions) {
        super(helper, dbMap);
        this.sourceId = source;
        this.reference = reference;
        this.targets = targets;
        this.positions = positions;
    }

    public Object execute() throws Exception {
        if (this.positions != null && !this.positions.isEmpty()) {
            return this.doMultiplePositions();
        }
        SQLStatement sql = null;
        sql = this.referenceInClassTable() ? StatementFactory.INSTANCE.createUpdateReferenceStatement(this.dbType, this.dbMap, this.sourceId, this.reference, this.targetId, this.position) : StatementFactory.INSTANCE.createInsertReferenceStatement(this.dbType, this.dbMap, this.sourceId, this.reference, this.targetId, this.position);
        Statement statement = this.helper.createStatement();
        String sqlString = sql.getStatement();
        if (debug) {
            System.out.println(sqlString);
        }
        this.helper.execute(statement, sqlString);
        statement.close();
        return null;
    }

    private Object doMultiplePositions() throws Exception {
        if (this.referenceInClassTable()) {
            this.doUpdates();
        } else {
            this.doInserts();
        }
        return null;
    }

    private void doInserts() throws Exception {
        StringBuffer buffer = new StringBuffer();
        DBMap.ReferenceData data = (DBMap.ReferenceData)this.dbMap.getDBRepresentation((EModelElement)this.reference);
        this.setSourceAndTarget(data);
        boolean order = false;
        buffer.append("INSERT INTO ");
        buffer.append(this.addQuotes(data.getTable().getName()));
        buffer.append(" ");
        buffer.append("(");
        buffer.append(this.addQuotes(this.source.getName()));
        buffer.append(", ");
        buffer.append(this.addQuotes(this.target.getName()));
        if (data.getOrderColumn() != null) {
            buffer.append(", ");
            buffer.append(this.addQuotes(data.getOrderColumn().getName()));
        }
        buffer.append(") ");
        buffer.append(" VALUES (");
        buffer.append(this.sourceId);
        buffer.append(", ");
        buffer.append('?');
        if (data.getOrderColumn() != null) {
            buffer.append(", ");
            buffer.append(this.position);
            order = true;
        }
        buffer.append(")");
        PreparedStatement ps = this.helper.createPreparedStatement(buffer.toString());
        PerfUtil p = new PerfUtil("SetReferenceCommand.doInserts() sql=" + buffer + ", size=" + this.positions.size(), true);
        for (int i = 0; i < this.positions.size(); ++i) {
            ps.setInt(1, (Integer)this.targets.get(i));
            if (order) {
                ps.setInt(2, (Integer)this.positions.get(i));
            }
            ps.addBatch();
        }
        try {
            this.helper.executeBatchedPreparedStatement(ps);
        }
        catch (Exception e) {
            p.stopAndPrintStatus(e.getLocalizedMessage());
            throw e;
        }
        ps.close();
        p.stopAndPrintStatus();
    }

    private void doUpdates() throws Exception {
        StringBuffer buffer = new StringBuffer();
        DBMap.ReferenceData data = (DBMap.ReferenceData)this.dbMap.getDBRepresentation((EModelElement)this.reference);
        this.setSourceAndTarget(data);
        boolean order = false;
        buffer.append("UPDATE ");
        buffer.append(this.addQuotes(data.getTable().getName()));
        buffer.append(" SET ");
        buffer.append(this.addQuotes(this.target.getName()));
        buffer.append(" = ");
        buffer.append('?');
        if (data.getOrderColumn() != null) {
            buffer.append(", ");
            buffer.append(this.addQuotes(data.getOrderColumn().getName()));
            buffer.append(" = ");
            buffer.append('?');
            order = true;
        }
        buffer.append(" WHERE ");
        buffer.append(this.addQuotes(this.source.getName()));
        buffer.append(" = ");
        if (this.sourceId == null) {
            buffer.append('?');
        } else {
            buffer.append(this.sourceId);
        }
        PreparedStatement ps = this.helper.createPreparedStatement(buffer.toString());
        PerfUtil p = new PerfUtil("SetReferenceCommand.doUpdates() sql=" + buffer + ", size=" + this.positions.size(), true);
        for (int i = 0; i < this.positions.size(); ++i) {
            if (this.sourceId == null) {
                ps.setInt(1, this.targetId);
            } else {
                ps.setInt(1, (Integer)this.targets.get(i));
            }
            if (order) {
                ps.setInt(2, (Integer)this.positions.get(i));
            }
            if (this.sourceId == null) {
                ps.setInt(order ? 3 : 2, (Integer)this.targets.get(i));
            }
            ps.addBatch();
        }
        try {
            this.helper.executeBatchedPreparedStatement(ps);
        }
        catch (Exception e) {
            p.stopAndPrintStatus(e.getLocalizedMessage());
            throw e;
        }
        ps.close();
        p.stopAndPrintStatus();
    }

    protected void setSourceAndTarget(DBMap.ReferenceData data) {
        this.source = data.getSourceColumn();
        this.target = data.getTargetColumn();
        if (this.isPrimaryKey(this.target)) {
            Column temp = this.target;
            this.target = this.source;
            this.source = temp;
            Integer temp2 = this.targetId;
            this.targetId = this.sourceId;
            this.sourceId = temp2;
        }
    }

    protected boolean isPrimaryKey(Column column) {
        EList constraints = column.getConstraints();
        int l = constraints.size();
        for (int i = 0; i < l; ++i) {
            Constraint constraint = (Constraint)constraints.get(i);
            if (!"PRIMARYKEY".equals(constraint.getType())) continue;
            return true;
        }
        return false;
    }

    protected boolean referenceInClassTable() {
        DBMap.ReferenceData data = (DBMap.ReferenceData)this.dbMap.getDBRepresentation((EModelElement)this.reference);
        Table table = data.getTable();
        return this.dbMap.getClassTables().contains(table);
    }
}

