/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Constraint;
import org.eclipse.hyades.resources.database.internal.dbmodel.SQLType;
import org.eclipse.hyades.resources.database.internal.dbmodel.StringType;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.impl.RDBHelper;
import org.eclipse.hyades.resources.database.internal.impl.SQLStatement;

public class TableStatement
extends SQLStatement {
    protected Table table;

    public TableStatement(DatabaseType dbType, DBMap map, Table table) {
        super(dbType, map);
        this.table = table;
    }

    public String getStatement() {
        if (this.statement.length() != 0) {
            return this.statement.toString();
        }
        this.statement.append("CREATE TABLE ");
        this.statement.append(this.addQuotes(this.table.getName()));
        this.statement.append(" (");
        RDBHelper rdbHelper = new RDBHelper();
        Column primaryKey = rdbHelper.getPrimaryKey(this.table);
        Constraint constraint = rdbHelper.getPrimaryKeyConstraint(this.table);
        EList columns = this.table.getColumns();
        int length = columns.size();
        for (int i = 0; i < length; ++i) {
            boolean primaryKeyFlag;
            Column column = (Column)columns.get(i);
            boolean bl = primaryKeyFlag = column == primaryKey;
            if (i == length - 1) {
                this.writeColumn(column, constraint, primaryKeyFlag, true);
                continue;
            }
            this.writeColumn(column, constraint, primaryKeyFlag, false);
        }
        this.statement.append(") ");
        this.statement.append(this.dbType.getTableSpaceString());
        return this.statement.toString();
    }

    protected void writeColumn(Column column, Constraint constraint, boolean primaryKey, boolean last) {
        this.statement.append("  ");
        this.statement.append(this.addQuotes(column.getName()));
        this.statement.append(" ");
        this.statement.append(this.getType(column.getType()));
        if (!column.isAllowNull()) {
            this.statement.append(" NOT NULL");
        }
        this.addDefaultValue(column);
        if (primaryKey) {
            this.statement.append(" PRIMARY KEY");
        }
        if (!last) {
            this.statement.append(",");
        }
    }

    protected void addDefaultValue(Column column) {
        if (column.getDefaultValue() != null) {
            this.statement.append(" ");
            this.statement.append(this.dbType.getDefaultString());
            this.statement.append(" ");
            if (column.getDefaultValue() instanceof String || column.getType().getSqlType() == 12) {
                this.statement.append("'");
                this.statement.append(column.getDefaultValue());
                this.statement.append("'");
            } else if (column.getDefaultValue() instanceof Boolean) {
                this.statement.append("'");
                this.statement.append((Boolean)column.getDefaultValue() != false ? (char)'1' : '0');
                this.statement.append("'");
            } else {
                this.statement.append(column.getDefaultValue());
            }
        }
    }

    protected String getType(SQLType type) {
        int jdbcType = type.getSqlType();
        switch (jdbcType) {
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INT";
            }
            case -5: {
                return "BIGINT";
            }
            case 8: {
                return "DOUBLE PRECISION";
            }
            case 1: {
                return "CHAR(" + ((StringType)type).getLength() + ")";
            }
            case -1: {
                return "LONG VARCHAR";
            }
        }
        return "VARCHAR(" + ((StringType)type).getLength() + ")";
    }
}

