/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.views;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModel;
import org.eclipse.hyades.logging.adapter.ui.internal.views.LogView;

public class AcadGuiModelManager {
    private static HashMap modelMap = new HashMap();
    private static AcadGuiModel currentModel;

    public static final void disposeModel(IFile file) {
        if (file == null || modelMap == null) {
            return;
        }
        String fileName = file.getFullPath().toOSString();
        Object[] keys = modelMap.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            Object model;
            Path ipath;
            ContextInstanceType context = (ContextInstanceType)keys[i];
            if (context.eResource() == null) {
                Object model2 = modelMap.get(context);
                if (model2 == null) continue;
                ((AcadGuiModel)model2).dispose();
                if (currentModel == model2) {
                    currentModel = null;
                }
                modelMap.remove(context);
                continue;
            }
            String path = context.eResource().getURI().path();
            if (path.startsWith("/resource")) {
                path = path.substring(9);
            }
            if (!(ipath = new Path(path)).toOSString().equals(fileName) || (model = modelMap.get(context)) == null) continue;
            ((AcadGuiModel)model).dispose();
            if (currentModel == model) {
                currentModel = null;
            }
            modelMap.remove(context);
        }
        LogView logView = LogView.getLogView(false);
        if (logView != null) {
            logView.set_Title();
        }
    }

    public static final void setCurrentModel(ContextInstanceType context) {
        boolean isNewModel = false;
        AcadGuiModel model = null;
        Object obj = modelMap.get(context);
        if (obj == null) {
            model = new AcadGuiModel();
            model.setContextInstance(context);
            modelMap.put(context, model);
            isNewModel = true;
        } else {
            model = (AcadGuiModel)obj;
        }
        if (currentModel != null && currentModel.getContextInstance() == model.getContextInstance()) {
            return;
        }
        currentModel = model;
        model.updateTestShow();
        model.updateResult();
        LogView logView = LogView.getLogView(true);
        if (logView != null) {
            logView.set_Title();
        }
    }

    public static final AcadGuiModel getCurrentModel() {
        return currentModel;
    }

    public static final AcadGuiModel getModel(ContextInstanceType context) {
        if (context == null) {
            return null;
        }
        return (AcadGuiModel)modelMap.get(context);
    }

    public static final SensorConfigType getLogForConfiguration(AcadGuiModel model) {
        if (model == null || model.getContextInstance() == null || model.getContextInstance().eContainer() == null) {
            return null;
        }
        return model.getContextInstance().getSensor();
    }
}

