/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.provider.ConfigurationItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.provider.ContextInstanceTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ContextInstanceSection extends Composite
								implements IDetails, ModifyListener
										   , INotifyChangedListener, SelectionListener
{
	protected Text descriptionText;		
	
	protected Button continousBtn;
	protected Text idleText;
	protected Text pauseText;	
	protected Label uniqueId;
	
    protected boolean isDisplaying;
    protected ContextInstanceType currentSelection;
    protected ContextInstanceTypeItemProvider itemProvider;
    protected ConfigurationItemProviderAdapterFactory itemFactory;
	
	
	public ContextInstanceSection(RuleBuilderWidgetFactory factory, Composite composite, int style){

		super(composite, style);
		
		itemFactory = new ConfigurationItemProviderAdapterFactory();

		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		detailLayout.verticalSpacing = 5;

		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
						
		Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_DESCR"), SWT.NONE);	
		descriptionText = factory.createText(this, "", SWT.MULTI);
		descriptionText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		
			
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_ID"), SWT.NONE);	
		uniqueId = factory.createLabel(this, "");
		uniqueId.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	
			
		label = factory.createLabel(this, "", SWT.NONE);	
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		

		continousBtn = factory.createButton(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_CONT"), SWT.CHECK);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		continousBtn.setLayoutData(data);		
		
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_TIME"), SWT.NONE);	
		idleText = factory.createText(this, "", SWT.NULL);
		idleText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		

		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONTEXTI_PAUSEI"), SWT.NONE);	
		pauseText = factory.createText(this, "", SWT.NULL);
		pauseText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		
			
		// add listeners - don't change the order in which the listeners are added
		// because of team support issues modify listeners should always be the last one added
		descriptionText.addModifyListener(this);
//		uniqueId.addModifyListener(this);
		idleText.addModifyListener(this);
		pauseText.addModifyListener(this);
		continousBtn.addSelectionListener(this);
		
		itemProvider = (ContextInstanceTypeItemProvider)itemFactory.createContextInstanceTypeAdapter();
		itemProvider.addListener(this);
	}
	
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {
      
		if(object != null)
			AcadGuiModelManager.setCurrentModel((ContextInstanceType)object);
			
		if(currentSelection == object)
		  return;
        
		if(descriptionText.isFocusControl() || uniqueId.isFocusControl() || idleText.isFocusControl()
		   || pauseText.isFocusControl() || continousBtn.isFocusControl())
		   
		  return;
        
		currentSelection = (ContextInstanceType)object;
		isDisplaying = true;
			
		descriptionText.setText(currentSelection.getDescription()==null?"":currentSelection.getDescription());
		uniqueId.setText(currentSelection.getUniqueID()==null?"":currentSelection.getUniqueID());
		idleText.setText(currentSelection.getMaximumIdleTime()==null?"":currentSelection.getMaximumIdleTime());
		pauseText.setText(currentSelection.getPauseInterval()==null?"":currentSelection.getPauseInterval());
		continousBtn.setSelection(currentSelection.isContinuousOperation());
		
		isDisplaying = false;
	}

	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {

 		this.currentSelection = (ContextInstanceType)currentSelection;
		
		this.currentSelection.setDescription(descriptionText.getText());
		this.currentSelection.setUniqueID(uniqueId.getText());
		this.currentSelection.setMaximumIdleTime(idleText.getText());
		this.currentSelection.setPauseInterval(pauseText.getText());
		this.currentSelection.setContinuousOperation(continousBtn.getSelection());
		
		return false;

	}
	
	public void setFocusToText(){
	        descriptionText.setFocus();
	        descriptionText.selectAll();
	}

	/**
	 * Sent when the text is modified.
	 *
	 * @param e an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e)
	{
		
		if(isDisplaying || currentSelection == null)
		  return;
		  
		if(e.getSource() == descriptionText)
		{
			String text = descriptionText.getText();
			if(!text.equals(currentSelection.getDescription()))
			{
				if(text.length() == 0 && currentSelection.getDescription() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ContextInstanceTypeItemProvider.DESCRIPTION);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}
		}		  
		else if(e.getSource() == uniqueId)
		{
			String text = uniqueId.getText();
			if(!text.equals(currentSelection.getUniqueID()))
			{
				if(text.length() == 0 && currentSelection.getUniqueID() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ContextInstanceTypeItemProvider.UNIQUE_ID);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}
		}
		else if(e.getSource() == idleText)
		{
			String text = idleText.getText();
			if(!text.equals(currentSelection.getMaximumIdleTime()))
			{
				if(text.length() == 0 && currentSelection.getMaximumIdleTime() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ContextInstanceTypeItemProvider.MAXIMUM_IDLE);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}
		}
		else if(e.getSource() == pauseText)
		{
			String text = pauseText.getText();
			if(!text.equals(currentSelection.getPauseInterval()))
			{
				if(text.length() == 0 && currentSelection.getPauseInterval() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ContextInstanceTypeItemProvider.PAUSE_INTERVAL);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}
		}
		
	}

	public void dispose() {
		
		itemFactory = null;
		itemProvider = null;
	}

	/**
	 */
	public void notifyChanged(Notification notification)
	{
		Object obj = notification.getNotifier();
		
		if(obj == null || (obj != currentSelection))
		  return;
		  
		display(currentSelection);
	}

	public void widgetSelected(SelectionEvent e)
	{
		if(e.getSource() == continousBtn)
		{
			boolean value = continousBtn.getSelection();
			if(value  != currentSelection.isContinuousOperation())
			{
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ContextInstanceTypeItemProvider.DESCRIPTION);
				
				String oldValue = currentSelection.getDescription();		
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, oldValue);	
					
				currentSelection.setContinuousOperation(value);
			}
		}
		
	}

	public void widgetDefaultSelected(SelectionEvent e)
	{
	}

}
