/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.action.model;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

/**
 * This class handles the remove action to remove elements that are {@link org.eclipse.emf.ecore.EStructuralFeature}
 * of an {@link org.eclipse.emf.ecore.EObject}.
 * 
 * @author bjiang
 * @since   1.3
 */
public class RemoveFeatureChildrenAction extends FeatureChildrenSelectionAction
{
	/**
	 * @param text
	 * @param parent
	 * @param feature
	 */	
	public RemoveFeatureChildrenAction(EObject parent, EStructuralFeature feature, boolean saveChanges)
	{
		super(TestUIPlugin.getString("BTN_REMOVE"), parent, feature); //$NON-NLS-1$

		if(saveChanges)
			setText(TestUIPlugin.getString("LBL_DELETE")); //$NON-NLS-1$
			
		setToolTipText(getText());
		ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
		setDisabledImageDescriptor(images.getImageDescriptor(ISharedImages.IMG_TOOL_DELETE_DISABLED));
		setImageDescriptor(images.getImageDescriptor(ISharedImages.IMG_TOOL_DELETE));		
		setHoverImageDescriptor(images.getImageDescriptor(ISharedImages.IMG_TOOL_DELETE_HOVER));
	}

	/**
	 * All the children must belong to the same parent.
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection selection)
	{
		if(!super.updateSelection(selection))
			return false;
		
		if((getStructuredViewer() == null) || (getChildren().size() != 1))
			return true;
			
		return (getStructuredViewer().getInput() != getChildren().get(0));
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);
		
		Object allChildren = getEStructuralFeatureValue();
		if(allChildren == null)
		    return;
		Object[] selections = getChildren().toArray();
		for(int i = 0; i < selections.length; i++)
		{		    
		    if(allChildren instanceof List)
		    {
				if(((List)allChildren).indexOf(selections[i]) > -1)
					//allChildren.remove(index);
				    EcoreUtil.remove(getParent(), getEStructuralFeature(), selections[i]);
		    }
		    else if(allChildren.equals(selections[i]))
		        EcoreUtil.remove(getParent(), getEStructuralFeature(), allChildren);
		}		

		setActionPerformed(true);
	}
}
