/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.model.ui;

import org.eclipse.hyades.test.ui.IHyadesTestNavigatorProvider;

/**
 * @author jcanches
 */
public interface ITypeProviderFactory {
	/** Returns the associated provider for the given type of element found in the HTN
	 * 
	 * @param type the type of element
	 * @return a provider for the given type <code>type</code> or <code>null</code> if the type does not exist (or problem has been encountered)
	 */
	IHyadesTestNavigatorProvider getProvider(String type);
}