package org.eclipse.hyades.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Feature Situation</b></em>'.
 * <P>
 * The FeatureSituation deals with the situations that announce that a feature 
 * of a component is now ready (or not ready) for service requests.  Situations 
 * that indicate things like services being available and services or features 
 * being unavailable fall into this category.  Existing situations include words 
 * like "now available", "currently available", and "transport is listening on port 
 * 123", for example:
 * </P>
 * <P>
 * <code>
 * SRVE0171I: Transport HTTPS is listening on port 9443
 * <br>
 * MSGS0601I: WebSphere Embedded Messaging has not been installed
 * </code>
 * </P>
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.FeatureSituation#getFeatureDisposition <em>Feature Disposition</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getFeatureSituation()
 * @model 
 * @generated
 */
public interface FeatureSituation extends SituationType {
    /**
     * <p>
     * Returns the value of the '<em><b>Feature Disposition</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Feature Disposition</em>' attribute.
     * @see #setFeatureDisposition(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getFeatureSituation_FeatureDisposition()
     * @model required="true"
     * @generated
     */
    String getFeatureDisposition();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.FeatureSituation#getFeatureDisposition <em>Feature Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <P>
     * This property specifies the availability disposition of a feature of a 
     * component that caused the situation to be reported.
     * The featureDisposition is a string with the following set of values:
     * <UL>
     * <LI>AVAILABLE</LI>
     * <LI>NOT AVAILABLE</LI>
     * </UL>
     * </p>
     * <p>
     * This is a <em>required</em> property and once it is set it <em>must not</em> change. The 
     * string length for this property <em>must not</em> exceed 64 characters.
     * </P>
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Feature Disposition</em>' attribute.
     * @see #getFeatureDisposition()
     * @generated
     */
    void setFeatureDisposition(String value);

	/**
	 * Resets the object's properties to their initial (e.g. null) state.
	 * 
	 * All components are initialized to either zero or null.
	 * 
	 * @since 1.0
	 */
	void init();
} // FeatureSituation
