package org.eclipse.hyades.logging.events.cbe.impl.tests;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

import javax.naming.NamingException;
import javax.naming.Reference;

import junit.framework.TestCase;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.ContentHandler;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryImpl;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryObjectFactory;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 */
public class EventFactoryImplTest extends TestCase implements Serializable {

    /**
     * Constructor for EventFactoryImplTest.
     * @param arg0
     */
    public EventFactoryImplTest(String arg0) {
        super(arg0);
    }

    /**
     * 
     */
    public void testInterface() {
        EventFactory efi = EventFactory.eINSTANCE;
        efi.getEventPackage();
        assertNotNull(efi.createAssociatedEvent());
        assertNotNull(efi.createAssociationEngine());
        assertNotNull(efi.createAvailableSituation());
        assertNotNull(efi.createCommonBaseEvent());
        assertNotNull(efi.createComponentIdentification());
        assertNotNull(efi.createConfigureSituation());
        assertNotNull(efi.createConnectSituation());
        assertNotNull(efi.createContextDataElement());
        assertNotNull(efi.createCreateSituation());
        assertNotNull(efi.createDependencySituation());
        assertNotNull(efi.createDestroySituation());
        assertNotNull(efi.createExtendedDataElement());
        assertNotNull(efi.createFeatureSituation());
        String guid = efi.createGlobalInstanceId();
        assertTrue("Guid must start with CE: " + guid, guid.startsWith("CE"));
        assertNotNull(efi.createMsgCatalogToken());
        assertNotNull(efi.createMsgDataElement());
        assertNotNull(efi.createOtherSituation());
        assertNotNull(efi.createReportSituation());
        assertNotNull(efi.createRequestSituation());
        assertNotNull(efi.createSituation());
        assertNotNull(efi.createStartSituation());
        assertNotNull(efi.createStopSituation());

        CommonBaseEvent cbe = efi.createCommonBaseEvent("A");
        assertEquals("A", cbe.getExtensionName());
        cbe = efi.createCommonBaseEvent("A", 5);
        assertEquals("A", cbe.getExtensionName());
        assertEquals(5, cbe.getCreationTimeAsLong());
    }

    /**
     * Tests the <code>create(EClass</code> method.
     */
    public void testEPackage() {
        //        EventFactory eFx = EventFactory.eINSTANCE;
        EPackage ePck = EventFactoryImpl.getPackage();
        List l = ePck.eContents();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            EClass c = (EClass) i.next();
            if (c.getName().equals("SituationType") || c.getName().equals("Serializable")) {
                try {
                    EventFactory.eINSTANCE.create(c);
                    fail(c.getName() + " is not an instantiatable class");
                }
                catch (IllegalArgumentException e) {
                    // expected
                }
            }
            else {
                EventFactory.eINSTANCE.create(c);
            }
        }
    }

    /**
     * Testing the contents of references returned by EventFactory.
     */
    public void testGetReference() {
        final String EXTENSION_NAME = "Example";
        ContentHandler mockHandler = new MockHandler(EXTENSION_NAME);
        EventFactoryImpl efi = new EventFactoryImpl();
        efi.setContentHandler(mockHandler);

        try {
            Reference ref = efi.getReference();
            assertEquals(EventFactoryObjectFactory.class.getName(), ref.getFactoryClassName());
            assertEquals(EventFactoryImpl.class.getName(), ref.getClassName());
            assertNotNull(ref.get(0));
        }
        catch (NamingException e) {
            fail("The reference should be valid.");
        }
    }

    /**
     * Testing whether the EventFactory is a JNDI citizen.
     *
     */
    public void testJndiSupport() {
        EventFactory efx = EventFactory.eINSTANCE;
        assertTrue("EventFactoryImpl must extend java.io.Serializable", efx instanceof java.io.Serializable);
        assertTrue("EventFactoryImpl must extend javax.naming.Referenceable", efx instanceof javax.naming.Referenceable);
    }

    /**
     * Tests whether the JNDI support will reject a non-serializable mediation handler. 
     */
    public void testNonSerializableHandler() {
        ContentHandler mockHandler = new ContentHandler() {
            public void completeEvent(CommonBaseEvent event) throws CompletionException {
                event.setExtensionName("Example");
            }
        };
        EventFactoryImpl efi = new EventFactoryImpl();
        efi.setContentHandler(mockHandler);
        try {
            Reference ref = efi.getReference();
            fail("Cannot accept non-serializable mediation handler");
        }
        catch (NamingException e) {
            Util.assertExceptionId("IWAT0188E", e);
        }
    }

    /*
     * Private methods. 
     */

    /**
     * 
     */
    public class MockHandler implements ContentHandler, Serializable {
        private String extensionName;

        public MockHandler(String name) {
            extensionName = name;
        }
        public void completeEvent(CommonBaseEvent event) throws CompletionException {
            event.setExtensionName(extensionName);
        }
    }
}
